<?php

namespace App\Http\Controllers\Admin;

use App\General\GeneralSettingsClass;
use App\Http\Controllers\API\Traits\UserTrait;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;
use Exception;
use Illuminate\Support\Facades\Session;
use App\Http\Controllers\Admin\EmailController;
use Carbon\Carbon;

class AuthController extends Controller
{
    use UserTrait;
    public function login(Request $request)
    {
        $credentials = $request->validate([
            'email' => 'required|email',
            'password' => 'required',
        ]);

        $user = User::where('email', $credentials['email'])->first();
        if (!$user) {
            return back()->withErrors([
                'email' => 'The provided credentials do not match our records.',
            ]);
        }
        if ($user->active == 0) {
            return back()->withErrors([
                'email' => 'Your Account is Inavtive Contect with admin.',
            ]);
        }
     

        if (Auth::attempt($credentials)) {
            $request->session()->regenerate();
            $permission = [];
            $key = 0;
           

            $request->session()->put('permissions', $permission);

            return redirect()->intended('/admin');
        }

        return back()->withErrors([
            'email' => 'The provided credentials do not match our records.',
        ]);
    }

    public function logout()
    {
        Auth::logout();
        return redirect('/');
    }

    public function register(Request $request)
    {
        // Validation logic here...

        $user = User::create([
            'name' => $request->input('name'),
            'email' => $request->input('email'),
            'password' => Hash::make($request->input('password')),
        ]);

        Auth::login($user);

        return redirect('/dashboard');
    }
    

    public function updatePassword(Request $request)
    { 
        $request->validate([
            'password' => 'required | confirmed | min:8',
            'token' => 'required'
        ]);

        $reset = DB::table('password_resets')
            ->where('token', $request->token)
            ->where('expires_at', '>', Carbon::now()) // or use config timezone
            ->first();

        
       
        if (!$reset) {
            return response()->json([
                'status' => 404,
                'message' => 'Invalid or Expired Reset Password Link!',
            ]);
        }
        // Get the user's email address from the password_resets table
        $email = $reset->email;
        
        // Update the user's password
        $user = User::where('email', $email)->first();
        $user->password = Hash::make($request->password);
        $user->save();
        
        // Delete the token from the password_resets table
        DB::table('password_resets')->where('email', $email)->delete();
        $logo = GeneralSettingsClass::getRequiredValue('_header_logo');
        
        $params = [
            'subject' => 'Password Reset Successfully | AutoParts',
            'to' => $user->email,
            'blade' => 'update-password',
            'msg' => view('Admin.Emails.update-password', [
                'name' => $user->name,
                'url' => route('Admin.Login'),
                'email' => $email,
                'password' => $request->password,
                'image_url' => url('/'),
                'logo' => $logo,
                ])->render(),
            ];

        $token = $user->createToken('authToken')->plainTextToken;
        $emailSent = $this->SendInstantEmail($params);
        if ($emailSent) {
            return response()->json([
                'status' => 200,
                'message' => 'Password Reset Confirmation Email has been sent to your Email.',
                'token' => $token,
            ]);
        } else {
            return response()->json([
                'status' => 200,
                'message' => 'Password Updated, SMTP ERROR occured while sending email!',
            ]);
        }
    }
}
