<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\GeneralSettings;
use App\General\GeneralSettingsClass;
use App\Models\NewsLetterSubscription;
use Illuminate\Http\Request;
use Intervention\Image\ImageManager;
use Illuminate\Support\Facades\DB;

class GeneralSettingsController extends Controller
{
    public function index()
    {
        $settings = GeneralSettings::get();
        $headerLogoDark = GeneralSettingsClass::getOptionValue('_header_logo_dark', $settings);
        $headerLogo = GeneralSettingsClass::getOptionValue('_header_logo', $settings);
        $favIcon = GeneralSettingsClass::getOptionValue('_fav_icon', $settings);
        return view('Admin.Settings.index', compact('settings', 'headerLogoDark', 'headerLogo', 'favIcon'));
    }
    
    public function store(Request $request)
    {
        $metaDescriptions = $request->only([
            '_tagline',
            '_header_logo',
            '_header_logo_dark',
            '_fav_icon', // <-- included here
            '_gst_percentage',
            '_truck_fixed_price',
            '_truck_per_cubic_meter_price',
            '_truck_per_hour_price',
            '_truck_per_kilometer_price',
            '_truck_minimum_distance',
            '_truck_maximum_distance',
            '_local_job_number_of_movers',
            '_local_job_mover_per_hour_price',
            '_local_job_minimum_order',
            '_local_job_deposit_amount',
            '_interstate_job_number_of_movers',
            '_interstate_job_mover_per_hour_price',
            '_interstate_job_minimum_order',
            '_interstate_job_deposit_percentage',
            '_mail_mailer',
            '_mail_host',
            '_mail_port',
            '_mail_username',
            '_mail_encrption',
            '_mail_password',
            '_mail_from_name',
            '_mail_from_address',
            '_active_stripe_environment',
            '_b_name',
            '_b_email',
            '_b_number',
            '_b_area_address',
            '_b_street_address',
            '_youtube_link',
            '_instagram_link',
            '_facebook_link',
            '_linke_din',
            '_twitter_link',
            '_abn',
            '_bank_details',
            '_bsb',
            '_acc',
            '_bank_name',
            '_hours_mon_fri_open',
            '_hours_mon_fri_close',
            '_hours_sat_open',
            '_hours_sat_close',
            '_hours_sun_closed',
            '_hours_sun_open',
            '_hours_sun_close',
            '_b_landline_number',
            '_whats_app_number',
            '_buffer_multiplier_time_percentage',
        ]);
    
        $settings = GeneralSettings::get();
    
        // Save header logo
        if ($request->hasFile('_header_logo')) {
            $image = $request->file('_header_logo');
            $imageName = time() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('logos'), $imageName);
            $metaDescriptions['_header_logo'] = 'logos/' . $imageName;
        } else {
            $headerLogo = GeneralSettingsClass::getOptionValue('_header_logo', $settings);
            if ($headerLogo) {
                $metaDescriptions['_header_logo'] = $headerLogo;
            }
        }
    
        // Save dark header logo
        if ($request->hasFile('_header_logo_dark')) {
            $image = $request->file('_header_logo_dark');
            $imageName = time() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('logos'), $imageName);
            $metaDescriptions['_header_logo_dark'] = 'logos/' . $imageName;
        } else {
            $headerLogoDark = GeneralSettingsClass::getOptionValue('_header_logo_dark', $settings);
            if ($headerLogoDark) {
                $metaDescriptions['_header_logo_dark'] = $headerLogoDark;
            }
        }
    
        // Save fav icon
        if ($request->hasFile('_fav_icon')) {
            $image = $request->file('_fav_icon');
            $imageName = 'favicon_' . time() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('logos'), $imageName);
            $metaDescriptions['_fav_icon'] = 'logos/' . $imageName;
        } else {
            $existingFavIcon = GeneralSettingsClass::getOptionValue('_fav_icon', $settings);
            if ($existingFavIcon) {
                $metaDescriptions['_fav_icon'] = $existingFavIcon;
            }
        }
    
        // Handle Sunday closed checkbox
        // Checkboxes only send value when checked, so check the request directly
        if ($request->has('_hours_sun_closed') && $request->_hours_sun_closed == '1') {
            $metaDescriptions['_hours_sun_closed'] = '1';
            // Clear Sunday hours if closed
            if (isset($metaDescriptions['_hours_sun_open'])) {
                $metaDescriptions['_hours_sun_open'] = '';
            }
            if (isset($metaDescriptions['_hours_sun_close'])) {
                $metaDescriptions['_hours_sun_close'] = '';
            }
        } else {
            // Sunday is open - set closed to 0 and preserve hours if provided
            $metaDescriptions['_hours_sun_closed'] = '0';
            // If Sunday hours are not in request, preserve existing values
            if (!isset($metaDescriptions['_hours_sun_open'])) {
                $existingSunOpen = GeneralSettingsClass::getOptionValue('_hours_sun_open', $settings);
                if ($existingSunOpen) {
                    $metaDescriptions['_hours_sun_open'] = $existingSunOpen;
                }
            }
            if (!isset($metaDescriptions['_hours_sun_close'])) {
                $existingSunClose = GeneralSettingsClass::getOptionValue('_hours_sun_close', $settings);
                if ($existingSunClose) {
                    $metaDescriptions['_hours_sun_close'] = $existingSunClose;
                }
            }
        }
        
        // Handle bases - store as JSON
        if ($request->has('_bases') && is_array($request->_bases)) {
            // Filter out empty bases
            $bases = array_filter($request->_bases, function($base) {
                return !empty($base['address']);
            });
            // Re-index array to ensure proper JSON encoding
            $bases = array_values($bases);
            
            // Ensure at least one base exists
            if (empty($bases)) {
                // If no bases provided, use default addresses
                $bases = [
                    ['address' => '76 Brunswick St, Fortitude Valley QLD 4006, Australia'],
                    ['address' => '55 Pyrmont Bridge Rd, Pyrmont NSW 2009, Australia']
                ];
            }
            
            $metaDescriptions['_bases'] = json_encode($bases);
        } else {
            // Preserve existing bases if not provided
            $existingBases = GeneralSettingsClass::getOptionValue('_bases', $settings);
            if ($existingBases) {
                $metaDescriptions['_bases'] = $existingBases;
            } else {
                // Initialize with default bases if none exist
                $defaultBases = [
                    ['address' => '76 Brunswick St, Fortitude Valley QLD 4006, Australia'],
                    ['address' => '55 Pyrmont Bridge Rd, Pyrmont NSW 2009, Australia']
                ];
                $metaDescriptions['_bases'] = json_encode($defaultBases);
            }
        }
        
        // Save settings
        $settingsMeta = [];
        foreach ($metaDescriptions as $option => $value) {
            if ($value !== null) {
                $settingsMeta[] = [
                    'option' => $option,
                    'value' => $value,
                ];
            }
        }
    
        DB::table('general_settings')->truncate();
        DB::table('general_settings')->insert($settingsMeta);
    
        // Update mail config
        config([
            'mail.mailer' => $request->_mail_mailer,
            'mail.host' => $request->_mail_host,
            'mail.port' => $request->_mail_port,
            'mail.username' => $request->_mail_username,
            'mail.password' => $request->_mail_password,
            'mail.encryption' => $request->_mail_encrption,
            'mail.from.name' => $request->_mail_from_name,
            'mail.from.address' => $request->_mail_from_address,
        ]);
    
        return redirect()->back()->with('success', 'General Settings Updated Successfully.');
    }
    


    public function newsletter_subscriptions()
    {
        $subscriptions = NewsLetterSubscription::latest()->get();
        return view('Admin.NewsLetters.index', compact('subscriptions'));
    }

}
