<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BlogCategory extends Model
{
    use HasFactory;

    protected $table = 'blog_categories';

    protected $fillable = [
        'title',
        'permalink',
        'description',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    // Get blogs that have this category in their blog_categories_id
    public function blogs()
    {
        return Blog::whereRaw('JSON_CONTAINS(blog_categories_id, ?)', [json_encode($this->id)]);
    }

    // Scope for active categories
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    // Scope for ordering by title
    public function scopeOrdered($query)
    {
        return $query->orderBy('title');
    }
}