<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Mailgun, Postmark, AWS and more. This file provides the de facto
    | location for this type of information, allowing packages to have
    | a conventional file to locate the various service credentials.
    |
    */
    'mailgun' => [
        'domain' => env('MAILGUN_DOMAIN'),
        'secret' => env('MAILGUN_SECRET'),
        'endpoint' => env('MAILGUN_ENDPOINT', 'api.mailgun.net'),
    ],

    'postmark' => [
        'token' => env('POSTMARK_TOKEN'),
    ],
    'stripe' => [
        'key' => env('STRIPE_KEY'),
        'secret' => env('STRIPE_SECRET'),
        'sandbox_secret' => env('STRIPE_SANDBOX_SECRET', 'sk_test_SjtPmG5srIbmgBeQhsA68sg800uGoRaNfn'),
        'live_secret' => env('STRIPE_LIVE_SECRET' ?? 'whsec_oznWqeEgavJgqcMZQzKYweI8QLxPTtAo'),
        'webhook_secret' => env('STRIPE_WEBHOOK_SECRET') ?? 'whsec_5e28f4tc60DuQ7dW2iJxVy9TjwEyTTsw',
    ],
    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],
    'paypal' => [
        'client_id' => env('PAYPAL_CLIENT_ID'),
        'client_secret' => env('PAYPAL_CLIENT_SECRET'),
        'settings' => [
            'mode' => env('PAYPAL_MODE', 'sandbox'), // or 'live'
            'http.ConnectionTimeOut' => 30,
        ],
    ],
    'recaptcha' => [
        'secret' => env('RECAPTCHA_SECRET_KEY', '6Lex7BMsAAAAAE-1ZO7pPTCQR3O2aBaZUF375vCi'),
    ],

];
