<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('trucks', function (Blueprint $table) {
            $table->id();
            
            // Basic Information
            $table->string('truck_name')->nullable();
            $table->string('truck_type')->nullable(); // light_rigid, medium_rigid, heavy_rigid, multi_combination
            $table->string('registration_number')->nullable();
            $table->string('vin_number')->nullable();
            $table->string('truck_image')->nullable();
            
            // Vehicle Details
            $table->string('make')->nullable();
            $table->string('model')->nullable();
            $table->year('year')->nullable();
            $table->string('engine_type')->nullable();
            $table->string('fuel_type')->nullable(); // diesel, petrol, electric, hybrid
            
            // Weight and Capacity
            $table->decimal('gross_vehicle_mass', 10, 2)->nullable(); // GVM in kg
            $table->decimal('tare_mass', 10, 2)->nullable(); // Tare weight in kg
            $table->decimal('payload_capacity', 10, 2)->nullable(); // Payload capacity in kg
            
            // Dimensions
            $table->decimal('dimensions_length', 8, 2)->nullable(); // Length in meters
            $table->decimal('dimensions_width', 8, 2)->nullable(); // Width in meters
            $table->decimal('dimensions_height', 8, 2)->nullable(); // Height in meters
            $table->decimal('cubic_capacity', 10, 2)->nullable(); // Cubic capacity in m³
            
            // Technical Specifications
            $table->string('axle_configuration')->nullable(); // e.g., "6x4", "8x4"
            $table->string('driving_license_required')->nullable(); // LR, MR, HR, HC, MC
            
            // Compliance and Documentation
            $table->date('insurance_expiry')->nullable();
            $table->date('registration_expiry')->nullable();
            $table->date('safety_inspection_due')->nullable();
            
            // Driver Information
            $table->string('driver_name')->nullable();
            $table->string('driver_license_number')->nullable();
            $table->string('driver_phone')->nullable();
            $table->string('driver_email')->nullable();
            
            // Operational Information
            $table->string('base_location')->nullable();
            $table->text('service_area')->nullable(); // JSON or text field for service areas
            $table->enum('availability_status', ['available', 'busy', 'maintenance', 'offline'])->default('available');
            
            // Pricing Configuration
            $table->enum('pricing_type', ['global', 'custom'])->default('global');
            $table->decimal('custom_fixed_price', 10, 2)->nullable();
            $table->decimal('custom_per_cubic_meter_price', 10, 2)->nullable();
            $table->decimal('custom_per_kilometer_price', 10, 2)->nullable();
            $table->decimal('custom_minimum_distance', 8, 2)->nullable();
            $table->decimal('custom_maximum_distance', 8, 2)->nullable();
            $table->decimal('custom_per_hour_price', 10, 2)->nullable();
            $table->integer('number_of_movers')->nullable();
            $table->integer('price_per_mover')->nullable();
            
            // Additional Information
            $table->text('notes')->nullable();
            $table->boolean('is_active')->default(true);
            $table->integer('sort_order')->default(0)->nullable();
            
            $table->timestamps();
            $table->softDeletes();
            
            // Indexes
            $table->index(['is_active', 'availability_status']);
            $table->index('registration_number');
            $table->index('truck_type');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('trucks');
    }
};
