<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('assemble_disassemble_categories', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description')->nullable();
            $table->string('image')->nullable();
            $table->decimal('assemble_price', 10, 2)->nullable()->default(0.00);
            $table->decimal('disassemble_price', 10, 2)->nullable()->default(0.00);
            $table->decimal('both_price', 10, 2)->nullable()->default(0.00);
            $table->integer('assemble_time_minutes')->nullable();
            $table->integer('disassemble_time_minutes')->nullable();
            $table->integer('both_time_minutes')->nullable();
            $table->boolean('is_active')->default(true);
            $table->integer('sort_order')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('assemble_disassemble_categories');
    }
};
