<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('booking_items', function (Blueprint $table) {
            $table->id();
            $table->string('uuid')->nullable();
            $table->string('entity_type')->nullable();
            $table->integer('entity_id')->nullable();
            $table->integer('quantity')->default(1);
            $table->boolean('is_assemble_disassemble')->default(false);
            $table->enum('assemble_disassemble_type', ['assemble', 'disassemble', 'both'])->nullable();
            $table->timestamps();
            
            // Indexes
            $table->index('uuid');
            $table->index('entity_type');
            $table->index('entity_id');
            $table->index('is_assemble_disassemble');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('booking_items');
    }
};