<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('quotes', function (Blueprint $table) {
            $table->id();
            $table->string('uuid')->nullable();
            $table->foreignId('booking_id')->nullable()->constrained('bookings')->nullOnDelete();
            $table->foreignId('truck_id')->nullable()->constrained('trucks')->nullOnDelete();
            $table->integer('user_id')->nullable();
            
            // Core inputs
            $table->decimal('distance_km', 10, 2)->nullable();
            $table->integer('total_time_minutes')->nullable();
            // Item calculations
            $table->decimal('total_cubic_meters', 10, 2)->nullable();
            $table->decimal('total_package_time_minutes', 10, 2);
            // Pricing components from truck
            $table->decimal('fixed_price', 10, 2)->nullable();
            $table->decimal('per_km_price', 10, 2)->nullable();
            $table->decimal('per_meter_cube_price', 10, 2)->nullable();
            $table->integer('number_of_movers')->nullable();
            $table->decimal('mover_per_hour_price', 10, 2)->nullable();
            // Calculated breakdown
            $table->decimal('distance_cost', 10, 2)->nullable();
            $table->decimal('volume_cost', 10, 2)->nullable();
            $table->decimal('movers_cost', 10, 2)->nullable();
            $table->decimal('total_cost', 10, 2)->nullable();
            $table->enum('status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->enum('quote_type', ['quote', 'estimate','order'])->default('quote');
            $table->string('quote_number')->nullable();
            $table->string('order_number')->nullable();
            $table->string('quote_payment_proof')->nullable();
            $table->string('payment_method')->nullable();
            $table->string('payment_type')->nullable();
            


            // Metadata
            $table->enum('calculation_type', ['items_only', 'items_and_packages', 'truck_only'])->nullable();
            $table->json('raw_data')->nullable();
            $table->timestamps();
            
            // Indexes
            $table->index('uuid');
            $table->index('booking_id');
            $table->index('truck_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('quotes');
    }
};
