<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payment_proofs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('quote_id')->constrained('quotes')->onDelete('cascade');
            $table->enum('payment_type', ['deposit', 'remaining'])->default('deposit');
            $table->string('proof_image'); // Path to uploaded image
            $table->decimal('amount', 10, 2); // Payment amount
            $table->enum('status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->integer('reviewed_by')->nullable(); // Admin user ID who reviewed
            $table->timestamp('reviewed_at')->nullable(); // When it was reviewed
            $table->text('notes')->nullable(); // Admin notes/reason for rejection
            $table->timestamps();
            
            // Indexes
            $table->index('quote_id');
            $table->index('status');
            $table->index('payment_type');
            $table->index('created_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payment_proofs');
    }
};
