<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Discount Applied to Your Order | {{ $settings['business_name'] ?? 'Speedy Move' }}</title>
    @include('Admin.Emails.partials.email-styles')
</head>
<body>
    <div class="email-container" style="width: 600px; margin: 0 auto; border: 1px solid #e9ecef;">
        <!-- Header - Simple White Background -->
        <div class="email-header">
            @if(!empty($settings['logo']))
                <img src="{{ $settings['image_url'] . '/' . $settings['logo'] }}" alt="{{ $settings['business_name'] ?? 'Speedy Move' }}">
            @else
                <h1 style="color: #01A7EF; margin: 0;">{{ $settings['business_name'] ?? 'Speedy Move' }}</h1>
            @endif
        </div>

        <!-- Body -->
        <div class="email-body">
            <h2 style="color: #01A7EF; margin-top: 0;">Great News! A Discount Has Been Applied</h2>
            
            <p><b>Dear {{ $user->name ?? 'Customer' }},</b></p>
            
            <p>We're pleased to inform you that a discount has been applied to your order. This discount has been adjusted to provide you with the best value for your move.</p>

            <div class="info-box" style="background-color: #e8f5e9; border-left-color: #198754;">
                <h3 style="color: #198754; margin-top: 0; font-size: 18px;">✓ Discount Confirmed</h3>
                <p style="margin: 10px 0; color: #333333;">
                    <b>Please note:</b> This discount has been applied to your order. If you see any previous discount amounts, they have been updated to reflect this new discount value.
                </p>
            </div>

            <div class="order-details-box">
                <h3 style="color: #01A7EF; margin-top: 0;">Order Information</h3>
                <table>
                    <tr>
                        <td><b>Order/Quote Number:</b></td>
                        <td>{{ $quote->order_number ?? $quote->quote_number ?? 'N/A' }}</td>
                    </tr>
                    @if($discountOnRemaining)
                        <tr>
                            <td><b>Original Remaining Amount:</b></td>
                            <td><span style="text-decoration: line-through; color: #999999;">${{ number_format($originalRemainingAmount, 2) }}</span></td>
                        </tr>
                        <tr>
                            <td><b>Discount Applied:</b></td>
                            <td><span style="color: #198754; font-weight: 600;">- ${{ number_format($discountAmount, 2) }}</span></td>
                        </tr>
                        <tr>
                            <td><b>New Remaining Amount:</b></td>
                            <td><span style="color: #01A7EF; font-weight: 700; font-size: 16px;">${{ number_format($quote->remaining_amount, 2) }}</span></td>
                        </tr>
                        <tr>
                            <td><b>Total Cost:</b></td>
                            <td>${{ number_format($quote->total_cost, 2) }}</td>
                        </tr>
                        <tr>
                            <td><b>Deposit Paid:</b></td>
                            <td>${{ number_format($quote->deposit_amount ?? 0, 2) }}</td>
                        </tr>
                    @else
                        <tr>
                            <td><b>Original Total Cost:</b></td>
                            <td><span style="text-decoration: line-through; color: #999999;">${{ number_format($originalTotalCost, 2) }}</span></td>
                        </tr>
                        <tr>
                            <td><b>Discount Applied:</b></td>
                            <td><span style="color: #198754; font-weight: 600;">- ${{ number_format($discountAmount, 2) }}</span></td>
                        </tr>
                        <tr>
                            <td><b>New Total Cost:</b></td>
                            <td><span style="color: #01A7EF; font-weight: 700; font-size: 16px;">${{ number_format($quote->total_cost, 2) }}</span></td>
                        </tr>
                        @if($quote->deposit_amount > 0)
                            <tr>
                                <td><b>Deposit Paid:</b></td>
                                <td>${{ number_format($quote->deposit_amount, 2) }}</td>
                            </tr>
                            <tr>
                                <td><b>Remaining Amount:</b></td>
                                <td><span style="color: #ff9800; font-weight: 600;">${{ number_format($quote->remaining_amount, 2) }}</span></td>
                            </tr>
                        @endif
                    @endif
                </table>
            </div>

            <div class="info-box" style="background-color: #e3f2fd; border-left-color: #01A7EF;">
                <h3 style="color: #01A7EF; margin-top: 0; font-size: 16px;">Discount Details</h3>
                <table style="width: 100%; margin-top: 10px;">
                    <tr>
                        <td style="padding: 5px 0;"><b>Discount Type:</b></td>
                        <td style="padding: 5px 0;">
                            @if($discountType === 'percentage')
                                Percentage ({{ number_format($discountValue, 2) }}%)
                            @else
                                Fixed Amount (${{ number_format($discountValue, 2) }})
                            @endif
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 5px 0;"><b>Discount Amount:</b></td>
                        <td style="padding: 5px 0; color: #198754; font-weight: 600;">${{ number_format($discountAmount, 2) }}</td>
                    </tr>
                    <tr>
                        <td style="padding: 5px 0;"><b>Applied On:</b></td>
                        <td style="padding: 5px 0;">
                            @if($discountOnRemaining)
                                <span style="color: #01A7EF; font-weight: 600;">Remaining Amount</span>
                                <br><small style="color: #666666;">(After deposit payment)</small>
                            @else
                                <span style="color: #01A7EF; font-weight: 600;">Total Cost</span>
                            @endif
                        </td>
                    </tr>
                </table>
            </div>

            @if($quote->remaining_amount > 0 && $quote->remaining_payment_url)
                <div class="payment-link-box">
                    <h3 style="color: #01A7EF; margin-top: 0;">Complete Your Payment</h3>
                    <p style="margin: 10px 0;">Your payment link has been updated with the new remaining amount after the discount:</p>
                    <p style="margin: 15px 0;">
                        <a href="{{ $quote->remaining_payment_url }}" class="btn-primary" style="display: inline-block; padding: 12px 30px; background-color: #01A7EF; color: #ffffff !important; text-decoration: none; border-radius: 5px; font-weight: 600;">
                            Pay ${{ number_format($quote->remaining_amount, 2) }}
                        </a>
                    </p>
                </div>
            @endif

            <div class="info-box" style="margin-top: 25px;">
                <b>Important Information:</b>
                <ul style="margin: 10px 0; padding-left: 20px; color: #333333;">
                    <li>This discount has been applied and confirmed to your order</li>
                    <li>If you had a previous discount, it has been updated to this new discount value</li>
                    <li>The discount is final and will be reflected in your final invoice</li>
                    <li>Your payment link (if applicable) has been automatically updated with the new amount</li>
                </ul>
            </div>

            @if(!empty($settings['business_email']) || !empty($settings['business_phone']))
                <div class="info-box">
                    <b>Need Help?</b>
                    <p style="margin: 10px 0 0 0;">If you have any questions about this discount or your order, our support team is here to help:</p>
                    @if(!empty($settings['business_email']))
                        <p style="margin: 5px 0;"><b>Email:</b> <a href="mailto:{{ $settings['business_email'] }}">{{ $settings['business_email'] }}</a></p>
                    @endif
                    @if(!empty($settings['business_phone']))
                        <p style="margin: 5px 0;"><b>Phone:</b> <a href="tel:{{ $settings['business_phone'] }}">{{ $settings['business_phone'] }}</a></p>
                    @endif
                </div>
            @endif

            <p style="margin-top: 25px;">Thank you for choosing {{ $settings['business_name'] ?? 'Speedy Move' }}. We appreciate your business!</p>

            <p style="margin-top: 20px;">
                <b>Best regards,</b><br>
                {{ $settings['business_name'] ?? 'Speedy Move' }} Team
            </p>
        </div>

        <!-- Footer - Light Gray -->
        @include('Admin.Emails.partials.email-footer')
    </div>
</body>
</html>

