
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Newsletter | {{ $settings['business_name'] ?? 'Speedy Move' }}</title>
    @include('Admin.Emails.partials.email-styles')
</head>
<body>
    <div class="email-container" style="width: 600px; margin: 0 auto; border: 1px solid #e9ecef;">
        <!-- Header -->
        <div class="email-header">
            @if(!empty($settings['logo']))
                <img src="{{ $settings['image_url'] . '/' . $settings['logo'] }}" alt="{{ $settings['business_name'] ?? 'Speedy Move' }}">
            @else
                <h1 style="color: #01A7EF; margin: 0;">{{ $settings['business_name'] ?? 'Speedy Move' }}</h1>
            @endif
        </div>
        
        <!-- Email Body -->
        <div class="email-body">
            <h2 style="color: #01A7EF; margin-top: 0;">Speedy Move Newsletter</h2>
            
            <b style="color: #000; font-size: 16px;">Thank you for subscribing to our newsletter!</b>
            <br><br>
            <span style="color: #000; line-height: 1.8;">We're thrilled to welcome you to our community. By subscribing, you've taken the first step towards staying informed about our latest updates, promotions, and insights. Get ready to receive exclusive content delivered straight to your inbox.</span>
            <br><br>
            
            <div class="info-box">
                <b style="color: #01A7EF; font-size: 16px;">What to Expect:</b>
                <ul style="color: #000; margin: 10px 0; padding-left: 20px; font-size: 14px; line-height: 1.8;">
                    <li>Latest updates and industry insights</li>
                    <li>Exclusive promotions and special offers</li>
                    <li>Product news and announcements</li>
                    <li>Helpful tips and resources</li>
                </ul>
            </div>
            
            <span style="color: #000; line-height: 1.8;">We're committed to providing you with valuable information and exciting offers that cater to your interests. Whether you're looking for industry insights, product news, or special discounts, our newsletter has got you covered.</span>
            <br><br>
            
            <span style="color: #000; line-height: 1.8;">Stay tuned for our upcoming emails, and don't forget to add 
                @if(!empty($settings['business_email']))
                    <a href="mailto:{{ $settings['business_email'] }}" style="color: #01A7EF; text-decoration: none; font-weight: 600;">{{ $settings['business_email'] }}</a>
                @else
                    <a href="mailto:sales@autopartstation.com.au" style="color: #01A7EF; text-decoration: none; font-weight: 600;">sales@autopartstation.com.au</a>
                @endif
                to your address book to ensure you don't miss out on any updates.</span>
            <br><br>
            
            <span style="color: #000; line-height: 1.8;">Once again, thank you for subscribing. We're excited to embark on this journey with you!</span>
            <br><br>
            
            @if(!empty($settings['business_email']) || !empty($settings['business_phone']))
                <div class="business-info">
                    <b style="color: #01A7EF; font-size: 16px;">Need Help?</b>
                    <br><br>
                    <span style="color: #000;">If you have any questions or need assistance, feel free to contact us:</span>
                    <br><br>
                    @if(!empty($settings['business_email']))
                        <b style="color: #000;">Email:</b> <a href="mailto:{{ $settings['business_email'] }}" style="color: #01A7EF; text-decoration: none; font-weight: 600;">{{ $settings['business_email'] }}</a>
                        <br>
                    @endif
                    @if(!empty($settings['business_phone']))
                        <b style="color: #000;">Phone:</b> <a href="tel:{{ $settings['business_phone'] }}" style="color: #01A7EF; text-decoration: none; font-weight: 600;">{{ $settings['business_phone'] }}</a>
                        <br>
                    @endif
                </div>
            @endif
            
            <span style="color: #000;">Thank you for using {{ $settings['business_name'] ?? 'Speedy Move' }}!</span>
        </div>
        
        <!-- Footer - Light Gray -->
        @include('Admin.Emails.partials.email-footer')
    </div>
</body>
</html>
