<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>New {{ $paymentTypeLabel }} Payment Proof Submitted | {{ $settings['business_name'] ?? 'Speedy Move' }}</title>
    @include('Admin.Emails.partials.email-styles')
</head>
<body>
    <div class="email-container" style="width: 600px; margin: 0 auto; border: 1px solid #e9ecef;">
        <!-- Header - Simple White Background -->
        <div class="email-header">
            @if(!empty($settings['logo']))
                <img src="{{ $settings['image_url'] . '/' . $settings['logo'] }}" alt="{{ $settings['business_name'] ?? 'Speedy Move' }}">
            @else
                <h1 style="color: #01A7EF; margin: 0;">{{ $settings['business_name'] ?? 'Speedy Move' }}</h1>
            @endif
        </div>

        <!-- Body -->
        <div class="email-body">
            <h2 style="color: #01A7EF; margin-top: 0;">New {{ $paymentTypeLabel }} Payment Proof Submitted</h2>
            
            <p><b>Dear Admin,</b></p>
            
            <p>A new {{ strtolower($paymentTypeLabel) }} payment proof has been submitted by a customer and requires your review.</p>

            <div class="info-box" style="background-color: #fff3cd; border-left-color: #ffc107;">
                <h3 style="color: #856404; margin-top: 0; font-size: 18px;">
                    ⚠ Payment Proof Pending Review
                </h3>
                <p style="margin: 10px 0; color: #333333;">
                    <strong>Payment Type:</strong> {{ $paymentTypeLabel }}<br>
                    <strong>Amount:</strong> ${{ number_format($amount, 2) }}<br>
                    <strong>Status:</strong> <span style="color: #ff9800; font-weight: 600;">Pending Review</span>
                </p>
            </div>

            <div class="info-box" style="background-color: #e3f2fd; border-left-color: #01A7EF;">
                <b>Order/Quote Number:</b> {{ $quote->order_number ?? $quote->quote_number ?? 'N/A' }}<br>
                <b>Order Date:</b> {{ $quote->created_at->format('F d, Y h:i A') }}<br>
                <b>Payment Method:</b> <span style="color: #01A7EF; font-weight: 600;">Bank Transfer</span><br>
                <b>Payment Type:</b> {{ $paymentTypeLabel }} Payment<br>
                <b>Proof Submission Date:</b> {{ $paymentProof->created_at->format('F d, Y h:i A') }}
            </div>

            <h3 style="color: #01A7EF; margin-top: 25px;">Customer Information</h3>
            
            <div class="order-details-box">
                <table>
                    <tr>
                        <td>Customer Name:</td>
                        <td>{{ $user->name ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                        <td>Email:</td>
                        <td><a href="mailto:{{ $user->email ?? 'N/A' }}">{{ $user->email ?? 'N/A' }}</a></td>
                    </tr>
                    @if($user->phone)
                    <tr>
                        <td>Phone:</td>
                        <td><a href="tel:{{ $user->phone }}">{{ $user->phone }}</a></td>
                    </tr>
                    @endif
                </table>
            </div>

            <h3 style="color: #01A7EF; margin-top: 25px;">Payment Details</h3>
            
            <div class="order-details-box">
                <table>
                    <tr>
                        <td><b>Total Order Amount:</b></td>
                        <td>${{ number_format($quote->total_cost ?? 0, 2) }}</td>
                    </tr>
                    @if($paymentType === 'deposit')
                        <tr>
                            <td><b>Deposit Amount (Proof):</b></td>
                            <td><span style="color: #01A7EF; font-weight: 600;">${{ number_format($amount, 2) }}</span></td>
                        </tr>
                        <tr>
                            <td><b>Expected Deposit:</b></td>
                            <td>${{ number_format($quote->deposit_amount ?? 0, 2) }}</td>
                        </tr>
                        <tr>
                            <td><b>Remaining Amount:</b></td>
                            <td><span style="color: #ff9800; font-weight: 600;">${{ number_format($quote->remaining_amount ?? 0, 2) }}</span></td>
                        </tr>
                    @else
                        <tr>
                            <td><b>Deposit Paid:</b></td>
                            <td><span style="color: #28a745; font-weight: 600;">${{ number_format($quote->deposit_amount ?? 0, 2) }}</span></td>
                        </tr>
                        <tr>
                            <td><b>Remaining Amount (Proof):</b></td>
                            <td><span style="color: #01A7EF; font-weight: 600;">${{ number_format($amount, 2) }}</span></td>
                        </tr>
                        <tr>
                            <td><b>Expected Remaining:</b></td>
                            <td><span style="color: #ff9800; font-weight: 600;">${{ number_format($quote->remaining_amount ?? 0, 2) }}</span></td>
                        </tr>
                    @endif
                    <tr>
                        <td><b>Payment Proof ID:</b></td>
                        <td>#{{ $paymentProof->id }}</td>
                    </tr>
                </table>
            </div>

            <div class="info-box" style="background-color: #d1ecf1; border-left-color: #01A7EF; margin-top: 25px;">
                <h3 style="color: #0c5460; margin-top: 0; font-size: 16px;">Action Required</h3>
                <p style="margin: 10px 0; color: #333333;">
                    Please review the payment proof and either approve or reject it through the admin panel.
                </p>
                <p style="margin: 10px 0; color: #333333;">
                    <strong>Payment Proof Image:</strong> <a href="{{ asset($paymentProof->proof_image) }}" target="_blank" style="color: #01A7EF; font-weight: 600;">View Payment Proof</a>
                </p>
            </div>

            <div class="info-box" style="margin-top: 25px;">
                <b>Next Steps:</b>
                <ul style="margin: 10px 0; padding-left: 20px; color: #333333;">
                    <li>Log in to the admin panel</li>
                    <li>Navigate to the quote/order details page</li>
                    <li>Review the payment proof image</li>
                    <li>Verify the payment amount matches the proof</li>
                    <li>Approve or reject the payment proof</li>
                    <li>The customer will be notified of your decision</li>
                </ul>
            </div>

            <p style="margin-top: 25px;">Please review this payment proof at your earliest convenience.</p>

            <p style="margin-top: 20px;">
                <b>Best regards,</b><br>
                {{ $settings['business_name'] ?? 'Speedy Move' }} System
            </p>
        </div>

        <!-- Footer - Light Gray -->
        @include('Admin.Emails.partials.email-footer')
    </div>
</body>
</html>

