<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>
        @if($action === 'approve')
            @if($paymentType === 'deposit')
                Deposit Payment Approved
            @else
                Remaining Amount Payment Approved
            @endif
        @else
            @if($paymentType === 'deposit')
                Deposit Payment Rejected
            @else
                Remaining Amount Payment Rejected
            @endif
        @endif | {{ $settings['business_name'] ?? 'Speedy Move' }}
    </title>
    @include('Admin.Emails.partials.email-styles')
</head>
<body>
    <div class="email-container" style="width: 600px; margin: 0 auto; border: 1px solid #e9ecef;">
        <!-- Header - Simple White Background -->
        <div class="email-header">
            @if(!empty($settings['logo']))
                <img src="{{ $settings['image_url'] . '/' . $settings['logo'] }}" alt="{{ $settings['business_name'] ?? 'Speedy Move' }}">
            @else
                <h1 style="color: #01A7EF; margin: 0;">{{ $settings['business_name'] ?? 'Speedy Move' }}</h1>
            @endif
        </div>

        <!-- Body -->
        <div class="email-body">
            <h2 style="color: #01A7EF; margin-top: 0;">
                @if($action === 'approve')
                    @if($paymentType === 'deposit')
                        Deposit Payment Approved
                    @else
                        Remaining Amount Payment Approved
                    @endif
                @else
                    @if($paymentType === 'deposit')
                        Deposit Payment Rejected
                    @else
                        Remaining Amount Payment Rejected
                    @endif
                @endif
            </h2>
            
            <p><b>Dear {{ $user->name ?? 'Customer' }},</b></p>
            
            @if($action === 'approve')
                @if($paymentType === 'deposit')
                    <p>Great news! Your deposit payment has been reviewed and approved by our team.</p>
                @else
                    <p>Excellent! Your remaining amount payment has been reviewed and approved by our team. Your order is now fully paid.</p>
                @endif
            @else
                @if($paymentType === 'deposit')
                    <p>We regret to inform you that your deposit payment has been reviewed and could not be approved at this time.</p>
                @else
                    <p>We regret to inform you that your remaining amount payment has been reviewed and could not be approved at this time.</p>
                @endif
            @endif

            @if($action === 'approve')
                <div class="info-box" style="background-color: #d4edda; border-left-color: #28a745;">
                    <h3 style="color: #28a745; margin-top: 0; font-size: 18px;">
                        ✓ 
                        @if($paymentType === 'deposit')
                            Deposit Approved
                        @else
                            Remaining Amount Approved
                        @endif
                    </h3>
                    <p style="margin: 10px 0; color: #333333;">
                        @if($paymentType === 'deposit')
                            Your deposit payment of <b>${{ number_format($quote->deposit_amount ?? 0, 2) }}</b> has been successfully reviewed and approved by {{ $settings['business_name'] ?? 'Speedy Move' }}. Thank you for your payment!
                        @else
                            Your remaining amount payment of <b>${{ number_format($originalRemainingAmount ?? $quote->remaining_amount ?? 0, 2) }}</b> has been successfully reviewed and approved by {{ $settings['business_name'] ?? 'Speedy Move' }}. Your order is now fully paid. Thank you!
                        @endif
                    </p>
                </div>
            @else
                <div class="info-box" style="background-color: #f8d7da; border-left-color: #dc3545;">
                    <h3 style="color: #dc3545; margin-top: 0; font-size: 18px;">
                        ✗ 
                        @if($paymentType === 'deposit')
                            Deposit Rejected
                        @else
                            Remaining Amount Rejected
                        @endif
                    </h3>
                    <p style="margin: 10px 0; color: #333333;">
                        @if($paymentType === 'deposit')
                            Your deposit payment of <b>${{ number_format($quote->deposit_amount ?? 0, 2) }}</b> has been reviewed and rejected by {{ $settings['business_name'] ?? 'Speedy Move' }}. Please review the details below and contact us if you have any questions.
                        @else
                            Your remaining amount payment of <b>${{ number_format($originalRemainingAmount ?? $quote->remaining_amount ?? 0, 2) }}</b> has been reviewed and rejected by {{ $settings['business_name'] ?? 'Speedy Move' }}. Please review the details below and contact us if you have any questions.
                        @endif
                    </p>
                </div>
            @endif

            <div class="order-details-box">
                <h3 style="color: #01A7EF; margin-top: 0;">Order Information</h3>
                <table>
                    <tr>
                        <td><b>Order/Quote Number:</b></td>
                        <td>{{ $quote->order_number ?? $quote->quote_number ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                        <td><b>Total Amount:</b></td>
                        <td>${{ number_format($quote->total_cost, 2) }}</td>
                    </tr>
                    @if($paymentType === 'deposit')
                        <tr>
                            <td><b>Deposit Amount:</b></td>
                            <td>
                                @if($action === 'approve')
                                    <span style="color: #28a745; font-weight: 600;">${{ number_format($quote->deposit_amount ?? 0, 2) }}</span>
                                @else
                                    <span style="color: #dc3545; font-weight: 600;">${{ number_format($quote->deposit_amount ?? 0, 2) }}</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <td><b>Remaining Amount:</b></td>
                            <td><span style="color: #ff9800; font-weight: 600;">${{ number_format($quote->remaining_amount ?? 0, 2) }}</span></td>
                        </tr>
                    @else
                        <tr>
                            <td><b>Deposit Paid:</b></td>
                            <td><span style="color: #28a745; font-weight: 600;">${{ number_format($quote->deposit_amount ?? 0, 2) }}</span></td>
                        </tr>
                        <tr>
                            <td><b>Remaining Amount:</b></td>
                            <td>
                                @if($action === 'approve')
                                    <span style="color: #28a745; font-weight: 600;">${{ number_format($originalRemainingAmount ?? $quote->remaining_amount ?? 0, 2) }} (Approved)</span>
                                @else
                                    <span style="color: #dc3545; font-weight: 600;">${{ number_format($quote->remaining_amount ?? 0, 2) }} (Rejected)</span>
                                @endif
                            </td>
                        </tr>
                    @endif
                    <tr>
                        <td><b>Payment Method:</b></td>
                        <td><span style="color: #01A7EF; font-weight: 600;">Bank Transfer</span></td>
                    </tr>
                    <tr>
                        <td><b>Payment Status:</b></td>
                        <td>
                            @if($action === 'approve')
                                <span style="color: #28a745; font-weight: 600;">✓ Approved</span>
                            @else
                                <span style="color: #dc3545; font-weight: 600;">✗ Rejected</span>
                            @endif
                        </td>
                    </tr>
                </table>
            </div>

            @if($action === 'approve')
                @if($paymentType === 'deposit' && !empty($quote->remaining_amount) && $quote->remaining_amount > 0)
                    <div class="info-box" style="background-color: #e3f2fd; border-left-color: #01A7EF; margin-top: 25px;">
                        <h3 style="color: #01A7EF; margin-top: 0; font-size: 16px;">Remaining Payment</h3>
                        <p style="margin: 10px 0; color: #333333;">
                            Your deposit has been approved. To complete your order, please pay the remaining amount of <b>${{ number_format($quote->remaining_amount, 2) }}</b>.
                        </p>
                        @if(!empty($quote->remaining_payment_url))
                            <p style="margin: 15px 0;">
                                <a href="{{ $quote->remaining_payment_url }}" class="btn-primary" style="display: inline-block; padding: 12px 30px; background-color: #01A7EF; color: #ffffff !important; text-decoration: none; border-radius: 5px; font-weight: 600;">
                                    Pay Remaining Amount (${{ number_format($quote->remaining_amount, 2) }})
                                </a>
                            </p>
                            <p style="margin: 10px 0; font-size: 13px; color: #666666;">
                                Or copy and paste this link into your browser:<br>
                                <a href="{{ $quote->remaining_payment_url }}" style="color: #01A7EF; word-break: break-all;">{{ $quote->remaining_payment_url }}</a>
                            </p>
                        @endif
                    </div>
                @endif

                <div class="info-box" style="margin-top: 25px;">
                    <b>Important Information:</b>
                    <ul style="margin: 10px 0; padding-left: 20px; color: #333333;">
                        @if($paymentType === 'deposit')
                            <li>Your deposit payment has been confirmed and approved</li>
                            @if(!empty($quote->remaining_amount) && $quote->remaining_amount > 0)
                                <li>Please complete the remaining payment before your scheduled move date</li>
                            @endif
                        @else
                            <li>Your remaining amount payment has been confirmed and approved</li>
                            <li>Your order is now fully paid and confirmed</li>
                        @endif
                        <li>Our team will contact you shortly to confirm your move date and time</li>
                        <li>If you have any questions, feel free to contact us</li>
                    </ul>
                </div>
            @else
                <div class="info-box" style="background-color: #fff3cd; border-left-color: #ffc107; margin-top: 25px;">
                    <h3 style="color: #856404; margin-top: 0; font-size: 16px;">What to Do Next</h3>
                    <ul style="margin: 10px 0; padding-left: 20px; color: #333333;">
                        @if($paymentType === 'deposit')
                            <li>Please review your payment proof to ensure it matches the deposit amount</li>
                        @else
                            <li>Please review your payment proof to ensure it matches the remaining amount</li>
                        @endif
                        <li>Contact our support team if you believe this is an error</li>
                        <li>You may need to resubmit your payment proof with correct information</li>
                        <li>Our team is ready to assist you in resolving this matter</li>
                    </ul>
                </div>

                <div class="info-box" style="margin-top: 25px;">
                    <b>Important Information:</b>
                    <ul style="margin: 10px 0; padding-left: 20px; color: #333333;">
                        @if($paymentType === 'deposit')
                            <li>Your deposit payment has been rejected and will need to be resubmitted</li>
                            <li>Your order is on hold until the deposit payment is approved</li>
                        @else
                            <li>Your remaining amount payment has been rejected and will need to be resubmitted</li>
                            <li>Please complete the remaining payment to finalize your order</li>
                        @endif
                        <li>Please contact us as soon as possible to resolve this issue</li>
                        <li>We are here to help you complete your payment successfully</li>
                    </ul>
                </div>
            @endif

            @if(!empty($settings['business_email']) || !empty($settings['business_phone']))
                <div class="info-box">
                    <b>Need Help?</b>
                    <p style="margin: 10px 0 0 0;">If you have any questions or need assistance, our support team is here to help:</p>
                    @if(!empty($settings['business_email']))
                        <p style="margin: 5px 0;"><b>Email:</b> <a href="mailto:{{ $settings['business_email'] }}">{{ $settings['business_email'] }}</a></p>
                    @endif
                    @if(!empty($settings['business_phone']))
                        <p style="margin: 5px 0;"><b>Phone:</b> <a href="tel:{{ $settings['business_phone'] }}">{{ $settings['business_phone'] }}</a></p>
                    @endif
                </div>
            @endif

            <p style="margin-top: 25px;">
                @if($action === 'approve')
                    Thank you for choosing {{ $settings['business_name'] ?? 'Speedy Move' }}. We look forward to serving you!
                @else
                    We apologize for any inconvenience. Please contact us so we can help you resolve this matter and proceed with your order.
                @endif
            </p>

            <p style="margin-top: 20px;">
                <b>Best regards,</b><br>
                {{ $settings['business_name'] ?? 'Speedy Move' }} Team
            </p>
        </div>

        <!-- Footer - Light Gray -->
        @include('Admin.Emails.partials.email-footer')
    </div>
</body>
</html>

