<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Complete Your Payment | {{ $settings['business_name'] ?? 'Speedy Move' }}</title>
    @include('Admin.Emails.partials.email-styles')
</head>
<body>
    <div class="email-container" style="width: 600px; margin: 0 auto; border: 1px solid #e9ecef;">
        <!-- Header - Simple White Background -->
        <div class="email-header">
            @if(!empty($settings['logo']))
                <img src="{{ $settings['image_url'] . '/' . $settings['logo'] }}" alt="{{ $settings['business_name'] ?? 'Speedy Move' }}">
            @else
                <h1 style="color: #01A7EF; margin: 0;">{{ $settings['business_name'] ?? 'Speedy Move' }}</h1>
            @endif
        </div>

        <!-- Body -->
        <div class="email-body">
            <h2 style="color: #01A7EF; margin-top: 0;">Complete Your Payment</h2>
            
            <p><b>Dear {{ $user->name ?? 'Customer' }},</b></p>
            
            <p>This is a reminder that you have a remaining payment balance for your order. Please complete the payment using the link below.</p>

            <div class="info-box">
                <b>Order Number:</b> {{ $quote->order_number ?? $quote->quote_number }}<br>
                <b>Total Amount:</b> ${{ number_format($quote->total_cost, 2) }}<br>
                <b>Deposit Paid:</b> ${{ number_format($quote->deposit_amount ?? 0, 2) }}<br>
                <b>Remaining Amount:</b> <span style="color: #01A7EF; font-weight: 600;">${{ number_format($quote->remaining_amount ?? 0, 2) }}</span>
            </div>

            <div class="payment-link-box">
                <h3 style="color: #01A7EF; margin-top: 0;">Pay Remaining Amount</h3>
                <p style="margin: 10px 0;">Click the button below to complete your payment:</p>
                <p style="margin: 15px 0;">
                    <a href="{{ $quote->remaining_payment_url }}" class="btn-primary" style="display: inline-block; padding: 12px 30px; background-color: #01A7EF; color: #ffffff !important; text-decoration: none; border-radius: 5px; font-weight: 600;">
                        Pay ${{ number_format($quote->remaining_amount ?? 0, 2) }}
                    </a>
                </p>
                <p style="margin: 10px 0; font-size: 13px; color: #666666;">
                    Or copy and paste this link into your browser:<br>
                    <a href="{{ $quote->remaining_payment_url }}" style="color: #01A7EF; word-break: break-all;">{{ $quote->remaining_payment_url }}</a>
                </p>
            </div>

            <div class="info-box" style="margin-top: 25px;">
                <b>Important Information:</b>
                <ul style="margin: 10px 0; padding-left: 20px; color: #333333;">
                    <li>Please complete the remaining payment before your scheduled move date</li>
                    <li>The payment link is secure and processed through Stripe</li>
                    <li>If you have any questions, please contact us</li>
                </ul>
            </div>

            @if(!empty($settings['business_email']) || !empty($settings['business_phone']))
                <div class="info-box">
                    <b>Need Help?</b>
                    <p style="margin: 10px 0 0 0;">If you have any questions or need assistance, our support team is here to help:</p>
                    @if(!empty($settings['business_email']))
                        <p style="margin: 5px 0;"><b>Email:</b> <a href="mailto:{{ $settings['business_email'] }}">{{ $settings['business_email'] }}</a></p>
                    @endif
                    @if(!empty($settings['business_phone']))
                        <p style="margin: 5px 0;"><b>Phone:</b> <a href="tel:{{ $settings['business_phone'] }}">{{ $settings['business_phone'] }}</a></p>
                    @endif
                </div>
            @endif

            <p style="margin-top: 25px;">Thank you for choosing {{ $settings['business_name'] ?? 'Speedy Move' }}. We look forward to serving you!</p>

            <p style="margin-top: 20px;">
                <b>Best regards,</b><br>
                {{ $settings['business_name'] ?? 'Speedy Move' }} Team
            </p>
        </div>

        <!-- Footer - Light Gray -->
        @include('Admin.Emails.partials.email-footer')
    </div>
</body>
</html>

