
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Password Reset OTP | {{ $settings['business_name'] ?? 'Speedy Move' }}</title>
    @include('Admin.Emails.partials.email-styles')
</head>

<body>
        <div class="email-container" style="width: 600px; margin: 0 auto; border: 1px solid #e9ecef;">
        <div class="email-header">
            @if(!empty($settings['logo']))
                <img src="{{ $settings['image_url'] . '/' . $settings['logo'] }}" alt="{{ $settings['business_name'] ?? 'Speedy Move' }}">
            @else
                <h1 style="color: #01A7EF; margin: 0;">{{ $settings['business_name'] ?? 'Speedy Move' }}</h1>
            @endif
        </div>
        <div class="email-body">
            <h2 style="color: #01A7EF; margin-top: 0;">Password Reset OTP</h2>
            <b>Dear {{ $user->name }},</b>
            <br><br>
            <span style="color:#000;">We received a request to reset your password for your {{ $settings['business_name'] }} account.</span>
            <br><br>
            
            <div class="otp-box">
                <h3 style="color: #000; margin-bottom: 15px; text-align: center;">Your Password Reset Code</h3>
                <div class="otp-code" style="text-align: center; margin: 20px auto;">{{ $otp }}</div>
                <p style="color: #6c757d; font-size: 16px; margin: 15px 0 0 0; text-align: center;">Enter this code to reset your password</p>
            </div>

            <div class="warning-box">
                <b style="color: #01A7EF; font-size: 16px;">⚠️ Important Security Information:</b>
                <ul style="color: #000; margin: 10px 0; padding-left: 20px; font-size: 14px; line-height: 1.8;">
                    <li>This code will expire in <strong>10 minutes</strong></li>
                    <li>Never share this code with anyone</li>
                    <li>If you didn't request this reset, please ignore this email</li>
                    <li>For security, change your password after logging in</li>
                </ul>
            </div>

            @if(!empty($settings['business_email']) || !empty($settings['business_phone']))
                <div class="business-info">
                    <b style="color: #01A7EF">Need Help?</b>
                    <br><br>
                    <span style="color: #000">If you're having trouble or didn't request this reset, contact our support team:</span>
                    <br><br>
                    @if(!empty($settings['business_email']))
                        <b style="color: #000">Email:</b> <a href="mailto:{{ $settings['business_email'] }}" style="color: #007bff;text-decoration: none;font-weight: 600;">{{ $settings['business_email'] }}</a>
                        <br>
                    @endif
                    @if(!empty($settings['business_phone']))
                        <b style="color: #000">Phone:</b> <a href="tel:{{ $settings['business_phone'] }}" style="color: #007bff;text-decoration: none;font-weight: 600;">{{ $settings['business_phone'] }}</a>
                        <br>
                    @endif
                </div>
            @endif

            <span style="color: #000">Thank you for using {{ $settings['business_name'] }}!</span>
        </div>
        
        <!-- Footer - Light Gray -->
        @include('Admin.Emails.partials.email-footer')
    </div>
</body>
</html>
