@include('Admin.Includes.header')

@php
    use Illuminate\Support\Facades\Auth;
    $logged_in_user = Auth::user();
@endphp

<div class="page-content">
    <div class="container-fluid">
        <div class="card shadow-sm mb-4">
            <div class="card-body py-3 services-body-card">
                <div class="d-flex justify-content-between align-items-center flex-wrap">
                    <div>
                        <h4 class="mb-1">{{ __('FAQ Management') }}</h4>

                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb bg-transparent p-0 m-0">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('Admin.Dashboard') }}" class="link-primary text-decoration-none">
                                        <i class="fa-solid fa-house me-1"></i> Dashboard
                                    </a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">
                                    FAQ Management
                                </li>
                            </ol>
                        </nav>
                    </div>

                    <div class="d-flex gap-2">
                        <a href="{{ route('faqs.create') }}" class="btn btn-success global-create-btn">
                            <i class="bi bi-plus-circle me-1"></i> Create FAQ
                        </a>
                    </div>
                </div>
            </div>
        </div>

    <!-- Stats Cards -->
    <div class="row">
        <div class="col-xl-3 col-md-6">
            <div class="card card-animate">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="avatar-sm flex-shrink-0">
                            <span class="avatar-title bg-primary-subtle text-primary rounded-circle fs-3">
                                <i class="bi bi-question-circle"></i>
                            </span>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <p class="text-uppercase fw-semibold fs-12 text-muted mb-1">Total FAQs</p>
                            <h4 class="mb-0" id="total_faqs">{{ $faqs->count() }}</h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card card-animate">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="avatar-sm flex-shrink-0">
                            <span class="avatar-title bg-success-subtle text-success rounded-circle fs-3">
                                <i class="bi bi-check-circle"></i>
                            </span>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <p class="text-uppercase fw-semibold fs-12 text-muted mb-1">Active</p>
                            <h4 class="mb-0" id="active_faqs">{{ $faqs->where('status', 1)->count() }}</h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card card-animate">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="avatar-sm flex-shrink-0">
                            <span class="avatar-title bg-warning-subtle text-warning rounded-circle fs-3">
                                <i class="bi bi-pause-circle"></i>
                            </span>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <p class="text-uppercase fw-semibold fs-12 text-muted mb-1">Inactive</p>
                            <h4 class="mb-0" id="inactive_faqs">{{ $faqs->where('status', 0)->count() }}</h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card card-animate">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="avatar-sm flex-shrink-0">
                            <span class="avatar-title bg-info-subtle text-info rounded-circle fs-3">
                                <i class="bi bi-list-ol"></i>
                            </span>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <p class="text-uppercase fw-semibold fs-12 text-muted mb-1">Total Q&As</p>
                            <h4 class="mb-0" id="total_questions">{{ $faqs->sum(function($faq) { return $faq->questions->count(); }) }}</h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content Card -->
    <div class="card shadow-sm">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="card-title mb-0">
                <i class="bi bi-list-ul me-2"></i>FAQs Table
            </h5>
          
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table id="data_Table" class="table table-borderless align-middle">
                    <thead class="table-light">
                        <tr>
                            <th class="sort" data-sort="id">#</th>
                            <th class="sort" data-sort="title">Title</th>
                            <th class="sort" data-sort="permalink">Permalink</th>
                            <th class="sort" data-sort="page_url">Page URL</th>
                            <th class="sort" data-sort="questions">Q&As</th>
                            <th class="sort" data-sort="sort_order">Sort Order</th>
                            <th class="sort" data-sort="status">Status</th>
                            <th class="sort" data-sort="created_at">Created Date</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody id="faq_table_body">
                        @php $i = 1; @endphp
                        @foreach ($faqs as $faq)
                            <tr>
                                <td><span class="fw-semibold">{{ $i++ }}</span></td>
                                <td>
                                    <div>
                                        <h6 class="mb-1">{{ Str::limit($faq->title, 40) }}</h6>
                                        @if ($faq->description)
                                            <small class="text-muted">{{ Str::limit(strip_tags($faq->description), 60) }}</small>
                                        @endif
                                    </div>
                                </td>
                                <td>
                                    <code class="text-primary">{{ $faq->permalink }}</code>
                                </td>
                                <td>
                                    @if ($faq->page_url)
                                        <a href="{{ $faq->page_url }}" target="_blank" class="text-decoration-none">
                                            {{ Str::limit($faq->page_url, 30) }}
                                            <i class="bi bi-box-arrow-up-right ms-1"></i>
                                        </a>
                                    @else
                                        <span class="text-muted">Not set</span>
                                    @endif
                                </td>
                                <td>
                                    <span class="badge bg-info-subtle text-info">
                                        {{ $faq->questions->count() }} Q&As
                                    </span>
                                </td>
                                <td>
                                    <span class="badge bg-secondary-subtle text-secondary">
                                        {{ $faq->sort_order }}
                                    </span>
                                </td>
                                <td class="active-status">
                                    @php
                                        $statusClass = [
                                            0 => 'bg-warning-subtle text-warning',
                                            1 => 'bg-success-subtle text-success',
                                        ];
                                        $statusText = [
                                            0 => 'Inactive',
                                            1 => 'Active',
                                        ];
                                    @endphp
                                    <span class="badge {{ $statusClass[$faq->status] ?? 'bg-light text-muted' }}">
                                        {{ $statusText[$faq->status] ?? 'Unknown' }}
                                    </span>
                                </td>
                                <td>
                                    <div>
                                        <span class="fw-medium">{{ $faq->created_at->format('M d, Y') }}</span>
                                        <br>
                                        <small class="text-muted">{{ $faq->created_at->format('h:i A') }}</small>
                                    </div>
                                </td>
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-sm text-dark rounded shadow-sm" type="button"
                                            data-bs-toggle="dropdown" aria-expanded="false"
                                            style="background-color: #c2d6e7;">
                                            &#8942;
                                        </button>
                                        <ul class="dropdown-menu">
                                            <li><a class="dropdown-item"
                                                    href="{{ route('faqs.edit', ['faq' => $faq->id]) }}">
                                                    <i class="bi bi-pencil-square me-2"></i>Edit</a>
                                            </li>

                                            <li>
                                                <a class="dropdown-item" href="{{ route('faqs.show', $faq) }}">
                                                    <i class="bi bi-eye me-2"></i>View
                                                </a>
                                            </li>

                                            <li><button class="dropdown-item text-danger"
                                                    data-bs-toggle="modal"
                                                    data-bs-target="#deleteConfirmModal{{ $faq->id }}">
                                                    <i class="bi bi-trash me-2"></i>Delete</button>
                                            </li>

                                            <li>
                                                <hr class="dropdown-divider">
                                            </li>
                                            <li>
                                                <a class="dropdown-item {{ $faq->status == 0 ? 'active' : '' }} cursor-pointer"
                                                    onclick="FAQUpdateStatus({{ $faq->id }}, 0, this)">
                                                    <i class="bi bi-pause me-2"></i> Inactive
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item {{ $faq->status == 1 ? 'active' : '' }} cursor-pointer"
                                                    onclick="FAQUpdateStatus({{ $faq->id }}, 1, this)">
                                                    <i class="bi bi-check-circle me-2"></i> Active
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </td>
                            </tr>

                            <!-- Delete Confirmation Modal -->
                            <div class="modal fade zoomIn" id="deleteConfirmModal{{ $faq->id }}"
                                tabindex="-1" aria-labelledby="deleteConfirmModalLabel{{ $faq->id }}"
                                aria-hidden="true">
                                <div class="modal-dialog modal-dialog-centered">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body p-md-5">
                                            <div class="text-center">
                                                <div class="text-danger">
                                                    <i class="bi bi-trash display-4"></i>
                                                </div>
                                                <div class="mt-4 fs-15">
                                                    <h4 class="mb-1">Are you sure?</h4>
                                                    <p class="text-muted mx-3 fs-16 mb-0">
                                                        Are you sure you want to delete
                                                        <strong>{{ $faq->title }}</strong>?<br>
                                                        This action cannot be undone.
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-light"
                                                data-bs-dismiss="modal">Cancel</button>
                                            <form method="POST" action="{{ route('faqs.destroy', $faq) }}" style="display: inline;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger">Yes, Delete</button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>



<style>
    .avatar-xs {
        height: 2rem;
        width: 2rem;
    }

    .avatar-sm {
        height: 3rem;
        width: 3rem;
    }

    .avatar-title {
        align-items: center;
        color: #fff;
        display: flex;
        font-weight: 500;
        height: 100%;
        justify-content: center;
        width: 100%;
    }

    .card-height-100 {
        height: calc(100% - 0px);
    }

    .cursor-pointer {
        cursor: pointer;
    }

    .table th.sort {
        cursor: pointer;
        user-select: none;
    }

    .table th.sort:hover {
        background-color: var(--bs-gray-100);
    }

    .badge {
        font-size: 0.75em;
    }

    .dropdown-item.active {
        color: black;
    }

    @media (max-width: 768px) {
        .card-body {
            padding: 1rem 0.5rem;
        }

        .table-responsive {
            font-size: 0.875rem;
        }
    }
</style>

<script>
    // FAQ Status Update Function
    function FAQUpdateStatus(faqId, status, elementObj) {
        const statusLabels = ['Inactive', 'Active'];
        const newStatusText = statusLabels[status] || 'Unknown';

        const statusClasses = {
            0: 'bg-warning-subtle text-warning',
            1: 'bg-success-subtle text-success',
        };

        $.ajax({
            url: '/admin/faqs/' + faqId + '/update-status',
            type: 'PUT',
            data: {
                status: status,
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                // Update status badge in the table
                const $statusCell = $(elementObj).closest('tr').find('.active-status .badge');
                $statusCell.removeClass().addClass('badge ' + statusClasses[status]).text(newStatusText);

                // Show success modal with SweetAlert2
                Swal.fire({
                    icon: 'success',
                    title: 'Status Updated',
                    text: `FAQ status updated to ${newStatusText} successfully.`,
                    timer: 2000,
                    showConfirmButton: false,
                    timerProgressBar: true
                });

                // Update stats cards
                updateStatsCards();
            },
            error: function(xhr) {
                const errorMessage = xhr.responseJSON?.message || 'Something went wrong.';
                
                // Show error modal with SweetAlert2
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: errorMessage,
                    confirmButtonText: 'OK'
                });
            }
        });
    }

    function searchFAQs(searchTerm) {
        const rows = document.querySelectorAll('tbody tr');
        rows.forEach(row => {
            const text = row.textContent.toLowerCase();
            if (text.includes(searchTerm.toLowerCase())) {
                row.style.display = '';
            } else {
                row.style.display = 'none';
            }
        });
    }

    function updateStatsCards() {
        const rows = $('tbody tr');
        let total = 0, active = 0, inactive = 0, totalQuestions = 0;

        rows.each(function() {
            const statusText = $(this).find('.active-status .badge').text().trim();
            total++;
            if (statusText === 'Active') active++;
            else if (statusText === 'Inactive') inactive++;
            
            // Count questions from Q&As badge
            const qaText = $(this).find('td:nth-child(5) .badge').text();
            const qaCount = parseInt(qaText.match(/\d+/)?.[0] || 0);
            totalQuestions += qaCount;
        });

        $('#total_faqs').text(total);
        $('#active_faqs').text(active);
        $('#inactive_faqs').text(inactive);
        $('#total_questions').text(totalQuestions);
    }

    // Auto-hide alerts
    setTimeout(function() {
        const alerts = document.querySelectorAll('.alert');
        alerts.forEach(alert => {
            alert.classList.remove('show');
            alert.classList.add('fade');
            setTimeout(() => alert.remove(), 500);
        });
    }, 5000);
</script>
