@include('Admin.Includes.header')

@php
    use Illuminate\Support\Facades\Auth;
    $logged_in_user = Auth::user();
@endphp

<div class="page-content">
    <div class="container-fluid">
        <div class="card shadow-sm mb-4">
            <div class="card-body py-3">
                <div class="d-flex justify-content-between align-items-center flex-wrap">
                    <div>
                        <h4 class="mb-1">{{ __('View FAQ') }}</h4>

                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb bg-transparent p-0 m-0">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('Admin.Dashboard') }}" class="link-primary text-decoration-none">
                                        <i class="fa-solid fa-house me-1"></i> Dashboard
                                    </a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="{{ route('faqs.index') }}" class="link-primary text-decoration-none">
                                        FAQs
                                    </a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">
                                    View FAQ
                                </li>
                            </ol>
                        </nav>
                    </div>

                    <div class="d-flex gap-2">
                        <a href="{{ route('faqs.index') }}" class="btn btn-primary">
                            <i class="bi bi-list me-1"></i> FAQ List
                        </a>
                        <a href="{{ route('faqs.edit', $faq) }}" class="btn btn-success">
                            <i class="bi bi-pencil-square me-1"></i> Edit FAQ
                        </a>
                    </div>
                </div>
            </div>
        </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <!-- Main Content -->
                        <div class="col-lg-8">
                            <!-- Basic Information -->
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h6 class="card-title mb-0">
                                        <i class="bi bi-info-circle me-2"></i>Basic Information
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label fw-semibold">Title</label>
                                                <p class="mb-0">{{ $faq->title }}</p>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <label class="form-label fw-semibold">Permalink</label>
                                                <p class="mb-0"><code class="text-primary">{{ $faq->permalink }}</code></p>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    @if($faq->page_url)
                                    <div class="mb-3">
                                        <label class="form-label fw-semibold">Page URL</label>
                                        <p class="mb-0">
                                            <a href="{{ $faq->page_url }}" target="_blank" class="text-decoration-none">
                                                {{ $faq->page_url }}
                                                <i class="bi bi-box-arrow-up-right ms-1"></i>
                                            </a>
                                        </p>
                                    </div>
                                    @endif
                                    
                                    @if($faq->description)
                                    <div class="mb-3">
                                        <label class="form-label fw-semibold">Description</label>
                                        <p class="mb-0">{{ $faq->description }}</p>
                                    </div>
                                    @endif
                                </div>
                            </div>

                            <!-- Questions & Answers -->
                            <div class="card">
                                <div class="card-header">
                                    <h6 class="card-title mb-0">
                                        <i class="bi bi-question-circle me-2"></i>Questions & Answers
                                        <span class="badge bg-primary-subtle text-primary ms-2">
                                            {{ count($faq->questions_answers ?? []) }} Q&As
                                        </span>
                                    </h6>
                                </div>
                                <div class="card-body">
                                    @if($faq->questions && count($faq->questions) > 0)
                                        @foreach($faq->questions()->ordered()->get() as $index => $question)
                                            <div class="qa-item border rounded p-3 mb-3 {{ $question->status == 0 ? 'opacity-50' : '' }}">
                                                <div class="d-flex justify-content-between align-items-start mb-2">
                                                    <div class="d-flex align-items-center">
                                                        <span class="badge bg-secondary-subtle text-secondary me-2">
                                                            #{{ $question->sort_order }}
                                                        </span>
                                                        <span class="badge {{ $question->status == 1 ? 'bg-success-subtle text-success' : 'bg-warning-subtle text-warning' }}">
                                                            {{ $question->status == 1 ? 'Active' : 'Inactive' }}
                                                        </span>
                                                    </div>
                                                </div>
                                                
                                                <div class="mb-3">
                                                    <h6 class="text-primary mb-2">
                                                        <i class="bi bi-question-circle me-1"></i>
                                                        Question {{ $index + 1 }}
                                                    </h6>
                                                    <p class="mb-0 fw-medium">{{ $question->question }}</p>
                                                </div>
                                                
                                                <div>
                                                    <h6 class="text-success mb-2">
                                                        <i class="bi bi-chat-dots me-1"></i>
                                                        Answer
                                                    </h6>
                                                    <div class="text-muted">
                                                        {!! nl2br(e($question->answer)) !!}
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    @else
                                        <div class="text-center py-4">
                                            <i class="bi bi-question-circle display-4 text-muted"></i>
                                            <h5 class="mt-3 text-muted">No Questions & Answers</h5>
                                            <p class="text-muted">This FAQ doesn't have any questions and answers yet.</p>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <!-- Sidebar -->
                        <div class="col-lg-4">
                            <!-- Status & Settings -->
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h6 class="card-title mb-0">
                                        <i class="bi bi-gear me-2"></i>Settings
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <label class="form-label fw-semibold">Status</label>
                                        <div class="mt-1">
                                            {!! $faq->getStatusBadge() !!}
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label fw-semibold">Sort Order</label>
                                        <p class="mb-0">
                                            <span class="badge bg-secondary-subtle text-secondary">
                                                {{ $faq->sort_order }}
                                            </span>
                                        </p>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label fw-semibold">Created By</label>
                                        <p class="mb-0">{{ $faq->creator->name ?? 'Unknown' }}</p>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label fw-semibold">Created Date</label>
                                        <p class="mb-0">{{ $faq->created_at->format('M d, Y h:i A') }}</p>
                                    </div>

                                    @if($faq->updated_at != $faq->created_at)
                                    <div class="mb-3">
                                        <label class="form-label fw-semibold">Last Updated</label>
                                        <p class="mb-0">{{ $faq->updated_at->format('M d, Y h:i A') }}</p>
                                    </div>
                                    @endif
                                </div>
                            </div>

                            <!-- Quick Actions -->
                            <div class="card">
                                <div class="card-header">
                                    <h6 class="card-title mb-0">
                                        <i class="bi bi-lightning me-2"></i>Quick Actions
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <div class="d-grid gap-2">
                                        <a href="{{ route('faqs.edit', $faq) }}" class="btn btn-success">
                                            <i class="bi bi-pencil-square me-1"></i>Edit FAQ
                                        </a>
                                        <button type="button" class="btn btn-danger" 
                                                data-bs-toggle="modal" data-bs-target="#deleteModal">
                                            <i class="bi bi-trash me-1"></i>Delete FAQ
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade zoomIn" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-md-5">
                <div class="text-center">
                    <div class="text-danger">
                        <i class="bi bi-trash display-4"></i>
                    </div>
                    <div class="mt-4 fs-15">
                        <h4 class="mb-1">Are you sure?</h4>
                        <p class="text-muted mx-3 fs-16 mb-0">
                            Are you sure you want to delete
                            <strong>{{ $faq->title }}</strong>?<br>
                            This action cannot be undone.
                        </p>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
                <form method="POST" action="{{ route('faqs.destroy', $faq) }}" style="display: inline;">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">Yes, Delete</button>
                </form>
            </div>
        </div>
    </div>
</div>

