<!-- HEAD SECTION -->
<meta charset="utf-8">
<meta http-equiv="x-ua-compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="description" content="">
<meta name="keyword" content="">
<meta name="author" content=""/>
<meta name="csrf-token" content="{{ csrf_token() }}">

<!-- App favicon -->
@php
    use App\General\GeneralSettingsClass;
    $favicon = GeneralSettingsClass::getRequiredValue('_fav_icon') ?? 'assets/images/favicon.png';
@endphp

<!-- App favicon -->
<link rel="shortcut icon" href="{{ asset($favicon) }}" type="image/x-icon">
<!-- CSS Libraries - External CDN Resources -->
<!-- Bootstrap CSS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
<!-- Icons Libraries -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-icons/1.11.3/font/bootstrap-icons.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css" integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<link href="https://cdn.materialdesignicons.com/7.2.96/css/materialdesignicons.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/remixicon/4.6.0/remixicon.min.css" integrity="sha512-XcIsjKMcuVe0Ucj/xgIXQnytNwBttJbNjltBV18IOnru2lDPe9KRRyvCXw6Y5H415vbBLRm8+q6fmLUU7DfO6Q==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css"/>
<!-- Select2 CSS -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<!-- Flatpickr CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">

<!-- Summernote Editor -->
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.20/dist/summernote-bs5.min.css" rel="stylesheet">
<style>
    .note-editor .note-toolbar {
        background: #f8f9fa;
        border-bottom: 1px solid #dee2e6;
        padding: 8px 10px;
    }
    .note-editor .note-toolbar .note-btn-group {
        margin-right: 5px;
    }
    .note-editor .note-toolbar .note-btn {
        padding: 6px 8px;
        border: 1px solid #dee2e6;
        background: #fff;
        color: #495057;
    }
    .note-editor .note-toolbar .note-btn:hover {
        background: #e9ecef;
        border-color: #adb5bd;
    }
    .note-editor .note-toolbar .note-btn.active {
        background: #007bff;
        color: #fff;
        border-color: #007bff;
    }
    .note-editor .note-toolbar .note-dropdown-menu {
        border: 1px solid #dee2e6;
        box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
    }
    .note-editor .note-toolbar .note-dropdown-menu .note-dropdown-item {
        padding: 6px 12px;
        color: #495057;
    }
    .note-editor .note-toolbar .note-dropdown-menu .note-dropdown-item:hover {
        background: #f8f9fa;
    }
    
    /* Fix dropdown menu visibility */
    .note-editor .note-toolbar .note-dropdown-menu {
        display: none;
        position: absolute;
        top: 100%;
        left: 0;
        z-index: 1000;
        min-width: 160px;
        padding: 5px 0;
        margin: 2px 0 0;
        background-color: #fff;
        border: 1px solid #ccc;
        border-radius: 4px;
        box-shadow: 0 6px 12px rgba(0,0,0,.175);
    }
    
    .note-editor .note-toolbar .note-btn-group.open .note-dropdown-menu {
        display: block;
    }
    
    .note-editor .note-toolbar .note-dropdown-menu .note-dropdown-item {
        display: block;
        padding: 3px 20px;
        clear: both;
        font-weight: normal;
        line-height: 1.42857143;
        color: #333;
        white-space: nowrap;
        cursor: pointer;
    }
    
    .note-editor .note-toolbar .note-dropdown-menu .note-dropdown-item:hover,
    .note-editor .note-toolbar .note-dropdown-menu .note-dropdown-item:focus {
        color: #262626;
        text-decoration: none;
        background-color: #f5f5f5;
    }
    
    /* Ensure dropdown buttons work */
    .note-editor .note-toolbar .note-btn-group {
        position: relative;
        display: inline-block;
        vertical-align: middle;
    }
    
    .note-editor .note-toolbar .note-btn-group > .note-btn {
        position: relative;
        float: left;
    }
    
    .note-editor .note-toolbar .note-btn-group > .note-btn:not(:first-child):not(:last-child):not(.dropdown-toggle) {
        border-radius: 0;
    }
    
    .note-editor .note-toolbar .note-btn-group > .note-btn:first-child:not(:last-child):not(.dropdown-toggle) {
        border-top-right-radius: 0;
        border-bottom-right-radius: 0;
    }
    
    .note-editor .note-toolbar .note-btn-group > .note-btn:last-child:not(:first-child),
    .note-editor .note-toolbar .note-btn-group > .dropdown-toggle:not(:first-child) {
        border-top-left-radius: 0;
        border-bottom-left-radius: 0;
    }
</style>


<!-- CSS Libraries - Local Resources -->
<!-- Layout config JS - Must be loaded before CSS -->
<script src="{{ asset('assets/js/layout.js') }}"></script>
<!-- Plugins CSS -->
<link href="{{ asset('assets/libs/jsvectormap/css/jsvectormap.min.css') }}" rel="stylesheet" type="text/css">
<link href="{{ asset('assets/libs/swiper/swiper-bundle.min.css') }}" rel="stylesheet" type="text/css">
<!-- Core CSS -->
<link href="{{ asset('assets/css/bootstrap.min.css') }}" rel="stylesheet" type="text/css">
<link href="{{ asset('assets/css/icons.min.css') }}" rel="stylesheet" type="text/css">
<link href="{{ asset('assets/css/app.min.css') }}" rel="stylesheet" type="text/css">
<link href="{{ asset('assets/css/newstyle.min.css') }}" rel="stylesheet" type="text/css">
<link href="{{ asset('assets/css/custom.min.css') }}" rel="stylesheet" type="text/css">
<!-- Form specific CSS -->

<!-- FOOTER SCRIPTS SECTION -->
<!-- Essential JavaScript Libraries -->
<!-- jQuery Core -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- Bootstrap Bundle -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous"></script>
<!-- Summernote Editor -->
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.20/dist/summernote-bs5.min.js"></script>
  <!-- Summernote Global Configuration -->
  <script>
  $(document).ready(function() {

      
      // Check if Summernote is loaded
      if (typeof $.fn.summernote === 'undefined') {
          return;
      }
      

      // Function to clean Google Docs content
      function cleanGoogleDocsContent(content) {
          if (!content) return '';
              
              // Remove Google Docs specific content
          content = content.replace(/<meta[^>]*>/gi, '');
          content = content.replace(/<link[^>]*>/gi, '');
          content = content.replace(/<!\[if[^>]*>.*?<!\[endif\]>/gsi, '');
          content = content.replace(/<!--.*?-->/gs, '');
              
              // Remove all style attributes
          content = content.replace(/\s*style\s*=\s*["'][^"']*["']/gi, '');
              
              // Remove all class attributes
          content = content.replace(/\s*class\s*=\s*["'][^"']*["']/gi, '');
              
              // Remove data-* attributes
          content = content.replace(/\s*data-[a-zA-Z0-9\-]*\s*=\s*["'][^"']*["']/gi, '');
              
              // Remove Word/Office specific tags
          content = content.replace(/<o:p[^>]*>.*?<\/o:p>/gsi, '');
          content = content.replace(/<w:[^>]*>.*?<\/w:[^>]*>/gsi, '');
          content = content.replace(/<m:[^>]*>.*?<\/m:[^>]*>/gsi, '');
          content = content.replace(/<v:[^>]*>.*?<\/v:[^>]*>/gsi, '');
              
              // Convert font tags to appropriate HTML
          content = content.replace(/<font[^>]*>(.*?)<\/font>/gsi, '$1');
              
              // Remove empty paragraphs
          content = content.replace(/<p[^>]*><\/p>/gi, '');
              
              // Clean paragraph tags
          content = content.replace(/<p[^>]*>/gi, '<p>');
              
              // Convert spans with bold/italic to proper tags
          content = content.replace(/<span[^>]*font-weight:\s*bold[^>]*>(.*?)<\/span>/gsi, '<strong>$1</strong>');
          content = content.replace(/<span[^>]*font-style:\s*italic[^>]*>(.*?)<\/span>/gsi, '<em>$1</em>');
              
              // Remove all other spans
          content = content.replace(/<span[^>]*>/gi, '');
          content = content.replace(/<\/span>/gi, '');
              
              // Remove div tags but keep content
          content = content.replace(/<div[^>]*>/gi, '');
          content = content.replace(/<\/div>/gi, '');
              
              // Clean up multiple spaces
          content = content.replace(/\s+/g, ' ');
              
              // Remove non-breaking spaces
          content = content.replace(/\u00A0/g, ' ');
          content = content.replace(/&nbsp;/g, ' ');
              
              // Limit content length
          if (content.length > 50000) {
              content = content.substring(0, 50000) + '...';
          }
          
          return content;
      }

      // Summernote initialization will be handled by specific selectors below

      // Initialize Summernote for specific IDs
      if (document.getElementById('_description')) {
          $('#_description').summernote({
              height: 300,
              minHeight: 200,
              maxHeight: 400,
              focus: false,
              toolbar: [
                  ['style', ['style']],
                  ['font', ['bold', 'italic', 'underline', 'strikethrough', 'clear']],
                  ['fontname', ['fontname']],
                  ['fontsize', ['fontsize']],
                  ['color', ['color']],
                  ['para', ['ul', 'ol', 'paragraph']],
                  ['table', ['table']],
                  ['insert', ['link', 'picture', 'video']],
                  ['view', ['fullscreen', 'codeview', 'help']]
              ],
              styleTags: ['p', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6'],
              followingToolbar: false,
              dialogsInBody: true,
              fontNames: ['Arial', 'Arial Black', 'Comic Sans MS', 'Courier New', 'Helvetica', 'Impact', 'Tahoma', 'Times New Roman', 'Verdana'],
              fontSizes: ['8', '9', '10', '11', '12', '14', '16', '18', '20', '24', '36', '48'],
              callbacks: {
                  onPaste: function(e) {
                      setTimeout(() => {
                          var content = $(this).summernote('code');
                          var cleanedContent = cleanGoogleDocsContent(content);
                          $(this).summernote('code', cleanedContent);
                      }, 100);
                  },
                  onChange: function(contents, $editable) {
                      $(this).val(contents);
                  }
              }
          });
      }
      
      // Initialize Summernote for other specific editors
      ['short_description', 'long_description'].forEach(function(id) {
          if (document.getElementById(id)) {
              $('#' + id).summernote({
                  height: 250,
                  minHeight: 150,
                  maxHeight: 350,
                  focus: false,
                  toolbar: [
                      ['style', ['style']],
                      ['font', ['bold', 'italic', 'underline', 'strikethrough', 'clear']],
                      ['fontname', ['fontname']],
                      ['fontsize', ['fontsize']],
                      ['color', ['color']],
                      ['para', ['ul', 'ol', 'paragraph']],
                      ['table', ['table']],
                      ['insert', ['link', 'picture', 'video']],
                      ['view', ['fullscreen', 'codeview', 'help']]
                  ],
                  styleTags: ['p', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6'],
              followingToolbar: false,
              dialogsInBody: true,
                  fontNames: ['Arial', 'Arial Black', 'Comic Sans MS', 'Courier New', 'Helvetica', 'Impact', 'Tahoma', 'Times New Roman', 'Verdana'],
              fontSizes: ['8', '9', '10', '11', '12', '14', '16', '18', '20', '24', '36', '48'],
                  callbacks: {
                      onPaste: function(e) {
                          setTimeout(() => {
                              var content = $(this).summernote('code');
                              var cleanedContent = cleanGoogleDocsContent(content);
                              $(this).summernote('code', cleanedContent);
                          }, 100);
                      },
                      onChange: function(contents, $editable) {
                          $(this).val(contents);
                      }
                  }
              });
          }
      });
      
      // Initialize Summernote for blog content
      if ($('textarea[name="content"]').length > 0) {
          
          $('textarea[name="content"]').summernote({
              height: 400,
              minHeight: 300,
              maxHeight: 600,
              focus: false,
              disableDragAndDrop: true,
              toolbar: [
                  ['style', ['style']],
                  ['font', ['bold', 'italic', 'underline', 'strikethrough', 'clear']],
                  ['fontname', ['fontname']],
                  ['fontsize', ['fontsize']],
                  ['color', ['color']],
                  ['para', ['ul', 'ol', 'paragraph']],
                  ['table', ['table']],
                  ['insert', ['link', 'picture', 'video']],
                  ['view', ['fullscreen', 'codeview', 'help']]
              ],
              styleTags: ['p', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6'],
              followingToolbar: false,
              dialogsInBody: true,
              fontNames: ['Arial', 'Arial Black', 'Comic Sans MS', 'Courier New', 'Helvetica', 'Impact', 'Tahoma', 'Times New Roman', 'Verdana'],
              fontSizes: ['8', '9', '10', '11', '12', '14', '16', '18', '20', '24', '36', '48'],
              shortcuts: false,
              popover: {
                  image: [
                      ['image', ['resizeFull', 'resizeHalf', 'resizeQuarter', 'resizeNone']],
                      ['float', ['floatLeft', 'floatRight', 'floatNone']],
                      ['remove', ['removeMedia']]
                  ],
                  link: [
                      ['link', ['linkDialogShow', 'unlink']]
                  ],
                  table: [
                      ['add', ['addRowDown', 'addRowUp', 'addColLeft', 'addColRight']],
                      ['delete', ['deleteRow', 'deleteCol', 'deleteTable']],
                  ],
                  air: [
                      ['color', ['color']],
                      ['font', ['bold', 'underline', 'clear']]
                  ]
              },
              callbacks: {
                  onPaste: function(e) {
                      setTimeout(() => {
                          var content = $(this).summernote('code');
                          var cleanedContent = cleanGoogleDocsContent(content);
                          $(this).summernote('code', cleanedContent);
                      }, 100);
                  },
                  onChange: function(contents, $editable) {
                      $(this).val(contents);
                  },
                  onInit: function() {                      
                      // Fix dropdown menus after initialization
                      setTimeout(function() {
                          var $editor = $('textarea[name="content"]').next('.note-editor');
                          if ($editor.length) {
                              
                              // Fix style dropdown
                              $editor.find('.note-toolbar .note-btn-group').each(function() {
                                  var $group = $(this);
                                  var $btn = $group.find('.note-btn');
                                  
                                  if ($btn.hasClass('dropdown-toggle')) {
                                      $btn.on('click', function(e) {
                                          e.preventDefault();
                                          e.stopPropagation();
                                          
                                          // Close other dropdowns
                                          $editor.find('.note-btn-group').removeClass('open');
                                          
                                          // Toggle current dropdown
                                          $group.toggleClass('open');
                                      });
                                  }
                              });
                              
                              // Close dropdowns when clicking outside
                              $(document).on('click', function(e) {
                                  if (!$(e.target).closest('.note-editor').length) {
                                      $editor.find('.note-btn-group').removeClass('open');
                                  }
                              });
                          }
                      }, 500);
                  }
              }
          });
      }

      // Also initialize for any textarea with rich-editor class that might not have been caught above
      $('.rich-editor').each(function() {
          if (!$(this).hasClass('note-editable')) {
              $(this).summernote({
                  height: 400,
                  minHeight: 300,
                  maxHeight: 600,
                  focus: false,
                  toolbar: [
                      ['style', ['style']],
                      ['font', ['bold', 'italic', 'underline', 'strikethrough', 'clear']],
                      ['fontname', ['fontname']],
                      ['fontsize', ['fontsize']],
                      ['color', ['color']],
                      ['para', ['ul', 'ol', 'paragraph']],
                      ['table', ['table']],
                      ['insert', ['link', 'picture', 'video']],
                      ['view', ['fullscreen', 'codeview', 'help']]
                  ],
                  styleTags: ['p', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6'],
              followingToolbar: false,
              dialogsInBody: true,
                  fontNames: ['Arial', 'Arial Black', 'Comic Sans MS', 'Courier New', 'Helvetica', 'Impact', 'Tahoma', 'Times New Roman', 'Verdana'],
              fontSizes: ['8', '9', '10', '11', '12', '14', '16', '18', '20', '24', '36', '48'],
                  callbacks: {
                      onPaste: function(e) {
                          setTimeout(() => {
                              var content = $(this).summernote('code');
                              var cleanedContent = cleanGoogleDocsContent(content);
                              $(this).summernote('code', cleanedContent);
                          }, 100);
                      },
                      onChange: function(contents, $editable) {
                          $(this).val(contents);
                      }
                  }
              });
          }
      });
  });

  // Helper functions for compatibility with existing code
  window.setSummernoteContent = function(selector, content) {
      $(selector).summernote('code', content || '');
  };

  window.getSummernoteContent = function(selector) {
      return $(selector).summernote('code');
  };

  // Legacy function names for backwards compatibility
  window.setTinyMCEContent = window.setSummernoteContent;
  window.getTinyMCEContent = window.getSummernoteContent;
  </script>

<!-- DataTables -->
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
<script>
    $(document).ready(function () {
        // Only initialize DataTable if it exists and hasn't been initialized yet
        if ($('#data_Table').length && !$.fn.DataTable.isDataTable('#data_Table')) {
            $('#data_Table').DataTable({
                responsive: true,
                autoWidth: false,
                columnDefs: [
                    { orderable: false, targets: -1 } // Disable sorting on "Actions" column
                ]
            });
        }
    });
</script>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>


<!-- Charting Libraries -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/apexcharts/3.40.0/apexcharts.min.js"></script>

<!-- Framework Components -->
<script src="{{ asset('assets/libs/simplebar/simplebar.min.js') }}"></script>
<script src="{{ asset('assets/js/plugins.js') }}"></script>

<!-- Map Libraries -->
<script src="{{ asset('assets/libs/jsvectormap/js/jsvectormap.min.js') }}"></script>
<script src="{{ asset('assets/libs/jsvectormap/maps/world-merc.js') }}"></script>

<!-- UI Components -->
<script src="{{ asset('assets/libs/swiper/swiper-bundle.min.js') }}"></script>
<script src="https://themesbrand.com/assets/libs/list.js/list.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<!-- Flatpickr -->
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>


<!-- Application Scripts -->
<script src="{{ asset('assets/js/pages/dashboard-ecommerce.init.js') }}"></script>
<script src="{{ asset('assets/js/app.js') }}"></script>
