@include('Admin.Includes.header')
@php
    use Illuminate\Support\Facades\Auth;
    $logged_in_user = Auth::user();
@endphp

<div class="page-content">
    <div class="card shadow-sm mb-4">
        <div class="p-3 d-flex justify-content-between align-items-center flex-wrap">
            <div class="clearfix">
                <div class="pd-t-5 pd-b-5">
                    <h1 class="fs-4 pd-0 mg-0 tx-20 tx-dark">{{ __('Job Applications') }}</h1>
                </div>

                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb bg-transparent p-0 m-0 align-items-center">
                        <li class="breadcrumb-item">
                            <a href="{{ url('/admin') }}" class="link-primary text-decoration-none">
                                <i class="fa-solid fa-home me-1"></i> Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Job Applications
                        </li>
                    </ol>
                </nav>
            </div>

            <div class="d-flex align-items-center gap-2">
                <button type="button" onclick="window.location = '{{ url('/admin/jobs') }}'"
                    class="btn btn-primary global-list-btn">
                    <i class="fa-solid fa-briefcase me-1"></i>Job Listings</button>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6">
            <div class="card card-height-100 border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="avatar-sm flex-shrink-0">
                            <span class="avatar-title bg-primary-subtle text-primary rounded fs-3">
                                <i class="bi bi-list-ul"></i>
                            </span>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <p class="text-uppercase fw-medium text-muted fs-12 mb-1">TOTAL APPLICATIONS</p>
                            <h4 class="mb-0">{{ $applications->count() }}</h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card card-height-100 border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="avatar-sm flex-shrink-0">
                            <span class="avatar-title bg-success-subtle text-success rounded fs-3">
                                <i class="bi bi-check-circle"></i>
                            </span>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <p class="text-uppercase fw-medium text-muted fs-12 mb-1">ACCEPTED</p>
                            <h4 class="mb-0">{{ $applications->where('status', 'accepted')->count() }}</h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card card-height-100 border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="avatar-sm flex-shrink-0">
                            <span class="avatar-title bg-warning-subtle text-warning rounded fs-3">
                                <i class="bi bi-clock"></i>
                            </span>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <p class="text-uppercase fw-medium text-muted fs-12 mb-1">PENDING</p>
                            <h4 class="mb-0">{{ $applications->where('status', 'pending')->count() }}</h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card card-height-100 border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="avatar-sm flex-shrink-0">
                            <span class="avatar-title bg-danger-subtle text-danger rounded fs-3">
                                <i class="bi bi-x-circle"></i>
                            </span>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <p class="text-uppercase fw-medium text-muted fs-12 mb-1">REJECTED</p>
                            <h4 class="mb-0">{{ $applications->where('status', 'rejected')->count() }}</h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Advanced Filters -->
    <div class="card mb-4">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="card-title mb-0">
                <i class="bi bi-funnel me-2"></i>Advanced Filters
            </h5>
            <button class="btn btn-primary btn-sm" type="button" data-bs-toggle="collapse" data-bs-target="#filterCollapse" aria-expanded="false" aria-controls="filterCollapse">
                <i class="bi bi-chevron-down"></i>
            </button>
        </div>
        <div class="collapse" id="filterCollapse">
            <div class="card-body">
                <form method="GET" action="{{ route('admin.job_applications.index') }}" id="filterForm">
                    <div class="row g-3">
                        <div class="col-xl-3 col-md-4">
                            <label class="form-label">Keyword</label>
                            <input type="text" class="form-control" name="keyword" value="{{ request('keyword') }}" placeholder="Search name, email...">
                        </div>
                        <div class="col-xl-2 col-md-4">
                            <label class="form-label">Status</label>
                            <select class="form-select" name="status">
                                <option value="">All Status</option>
                                <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                                <option value="reviewed" {{ request('status') == 'reviewed' ? 'selected' : '' }}>Reviewed</option>
                                <option value="shortlisted" {{ request('status') == 'shortlisted' ? 'selected' : '' }}>Shortlisted</option>
                                <option value="interviewed" {{ request('status') == 'interviewed' ? 'selected' : '' }}>Interviewed</option>
                                <option value="accepted" {{ request('status') == 'accepted' ? 'selected' : '' }}>Accepted</option>
                                <option value="rejected" {{ request('status') == 'rejected' ? 'selected' : '' }}>Rejected</option>
                            </select>
                        </div>
                        <div class="col-xl-2 col-md-4">
                            <label class="form-label">Job</label>
                            <select class="form-select" name="job_id">
                                <option value="">All Jobs</option>
                                @foreach($jobs as $job)
                                    <option value="{{ $job->id }}" {{ request('job_id') == $job->id ? 'selected' : '' }}>
                                        {{ $job->title }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-xl-2 col-md-6">
                            <label class="form-label">Date From</label>
                            <input type="date" class="form-control" name="date_from" value="{{ request('date_from') }}">
                        </div>
                        <div class="col-xl-2 col-md-6">
                            <label class="form-label">Date To</label>
                            <input type="date" class="form-control" name="date_to" value="{{ request('date_to') }}">
                        </div>
                        <div class="col-lg-1 col-md-12">
                            <div class="d-flex gap-1 mt-xl-4 pt-xl-1">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fa-solid fa-search"></i>
                                </button>
                                <button type="button" class="btn btn-secondary" onclick="clearFilters()">
                                    <i class="fa-solid fa-times"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center flex-wrap">
            <h5 class="card-title mb-0">
                <i class="bi bi-list-ul me-2"></i>Applications Table
            </h5>
            <div class="d-flex align-items-center flex-wrap gap-3 mt-md-0 mt-3">
                <div class="d-flex align-items-center">
                    <label class="form-label me-2 mb-0">Show:</label>
                    <select class="form-select form-select-sm" style="width: auto;" id="entriesPerPage">
                        <option value="10">10</option>
                        <option value="25" selected>25</option>
                        <option value="50">50</option>
                        <option value="100">100</option>
                    </select>
                    <span class="ms-1">entries</span>
                </div>
                <div class="d-flex align-items-center">
                    <label class="form-label me-2 mb-0">Search:</label>
                    <input type="text" class="form-control form-control-sm" placeholder="Search applications..." id="searchInput" style="width: 200px;">
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table id="data_Table" class="table table-borderless">
                    <thead>
                        <tr>
                            <th>Applicant</th>
                            <th>Job Title</th>
                            <th>Contact Info</th>
                            <th>Status</th>
                            <th>Applied Date</th>
                            <th>CV File</th>
                            <th width="180px">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($applications as $application)
                            <tr class="align-middle">
                                <td>
                                    <div class="fw-semibold">{{ $application->full_name }}</div>
                                    <small class="text-muted">{{ Str::limit($application->cover_letter, 50) }}</small>
                                </td>
                                <td>
                                    <div class="fw-semibold">{{ $application->job->title }}</div>
                                    <small class="text-muted">{{ $application->job->location }}</small>
                                </td>
                                <td>
                                    <div><i class="fa-solid fa-envelope me-1"></i>{{ $application->email }}</div>
                                    @if($application->phone)
                                        <div><i class="fa-solid fa-phone me-1"></i>{{ $application->phone }}</div>
                                    @endif
                                </td>
                                <td>
                                    @php
                                        $statusColors = [
                                            'pending' => 'warning',
                                            'reviewed' => 'info',
                                            'shortlisted' => 'primary',
                                            'interviewed' => 'secondary',
                                            'accepted' => 'success',
                                            'rejected' => 'danger'
                                        ];
                                        $color = $statusColors[$application->status] ?? 'secondary';
                                    @endphp
                                    <span class="badge bg-{{ $color }}-subtle text-{{ $color }} px-3 py-2">
                                        {{ ucfirst($application->status) }}
                                    </span>
                                </td>
                                <td>{{ $application->created_at->format('M d, Y H:i') }}</td>
                                <td>
                                    @if($application->cv_file)
                                        <a href="{{ asset('job_applications/' . $application->cv_file) }}" 
                                           download="{{ $application->cv_file }}" class="btn btn-sm btn-outline-primary">
                                            <i class="fa-solid fa-download me-1"></i>Download
                                        </a>
                                    @else
                                        <span class="text-muted">No CV</span>
                                    @endif
                                </td>
                                <td>
                                    <div class="dropdown">
                                        <button class="btn btn-sm text-dark rounded shadow-sm"
                                            type="button" data-bs-toggle="dropdown" aria-expanded="false"
                                            style="background-color: #c2d6e7;">
                                            &#8942;
                                        </button>
                                        <ul class="dropdown-menu">
                                            <li>
                                                <button class="dropdown-item" onclick="viewApplication({{ $application->id }})">
                                                    <i class="bi bi-eye me-2"></i> View Details
                                                </button>
                                            </li>
                                            <li>
                                                <hr class="dropdown-divider">
                                            </li>
                                            <li>
                                                <button class="dropdown-item" onclick="updateApplicationStatus({{ $application->id }}, 'pending', this)">
                                                    <i class="bi bi-clock me-2"></i> Mark as Pending
                                                </button>
                                            </li>
                                            <li>
                                                <button class="dropdown-item" onclick="updateApplicationStatus({{ $application->id }}, 'reviewed', this)">
                                                    <i class="bi bi-check-circle me-2"></i> Mark as Reviewed
                                                </button>
                                            </li>
                                            <li>
                                                <button class="dropdown-item" onclick="updateApplicationStatus({{ $application->id }}, 'shortlisted', this)">
                                                    <i class="bi bi-star me-2"></i> Shortlist
                                                </button>
                                            </li>
                                            <li>
                                                <button class="dropdown-item" onclick="updateApplicationStatus({{ $application->id }}, 'interviewed', this)">
                                                    <i class="bi bi-person-check me-2"></i> Mark as Interviewed
                                                </button>
                                            </li>
                                            <li>
                                                <button class="dropdown-item text-success" onclick="updateApplicationStatus({{ $application->id }}, 'accepted', this)">
                                                    <i class="bi bi-check-circle-fill me-2"></i> Accept
                                                </button>
                                            </li>
                                            <li>
                                                <button class="dropdown-item text-danger" onclick="updateApplicationStatus({{ $application->id }}, 'rejected', this)">
                                                    <i class="bi bi-x-circle me-2"></i> Reject
                                                </button>
                                            </li>
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                            <th>Applicant</th>
                            <th>Job Title</th>
                            <th>Contact Info</th>
                            <th>Status</th>
                            <th>Applied Date</th>
                            <th>CV File</th>
                            <th width="180px">Actions</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Application View Modal -->
<div class="modal fade" id="applicationViewModal" tabindex="-1" aria-labelledby="applicationViewModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="applicationViewModalLabel">Application Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="applicationViewContent">
                <!-- Content will be loaded here -->
            </div>
        </div>
    </div>
</div>

<!-- Status Update Modal -->
<div class="modal fade" id="statusUpdateModal" tabindex="-1" aria-labelledby="statusUpdateModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="statusUpdateModalLabel">Update Application Status</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="statusUpdateForm">
                    <input type="hidden" id="applicationId" name="application_id">
                    <div class="mb-3">
                        <label class="form-label">Status</label>
                        <select class="form-select" name="status" id="statusSelect" required>
                            <option value="pending">Pending</option>
                            <option value="reviewed">Reviewed</option>
                            <option value="shortlisted">Shortlisted</option>
                            <option value="interviewed">Interviewed</option>
                            <option value="accepted">Accepted</option>
                            <option value="rejected">Rejected</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Notes (Optional)</label>
                        <textarea class="form-control" name="notes" rows="3" placeholder="Add any notes about this application..."></textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary" onclick="submitStatusUpdate()">Update Status</button>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        // Check if DataTable is already initialized and destroy it first
        if ($.fn.DataTable.isDataTable('#data_Table')) {
            $('#data_Table').DataTable().destroy();
        }

        // Initialize DataTable
        var table = $('#data_Table').DataTable({
            "processing": true,
            "serverSide": false,
            "responsive": true,
            "pageLength": 25,
            "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
            "order": [[4, "desc"]], // Sort by Applied Date column descending
            "columnDefs": [
                {
                    "targets": [6], // Actions column
                    "orderable": false,
                    "searchable": false
                }
            ],
            "language": {
                "search": "",
                "lengthMenu": "",
                "info": "Showing _START_ to _END_ of _TOTAL_ entries",
                "infoEmpty": "Showing 0 to 0 of 0 entries",
                "infoFiltered": "(filtered from _MAX_ total entries)",
                "paginate": {
                    "first": "First",
                    "last": "Last",
                    "next": "Next",
                    "previous": "Previous"
                },
                "emptyTable": "No applications found"
            },
            "dom": '<"row"<"col-sm-12"tr>>' +
                   '<"row"<"col-sm-12 col-md-5"i><"col-sm-12 col-md-7"p>>',
        });

        // Custom search functionality
        $('#searchInput').on('keyup', function() {
            table.search(this.value).draw();
        });

        // Custom entries per page functionality
        $('#entriesPerPage').on('change', function() {
            table.page.len(parseInt(this.value)).draw();
        });
    });

    // Clear filters function
    function clearFilters() {
        document.getElementById('filterForm').reset();
        window.location.href = "{{ route('admin.job_applications.index') }}";
    }

    // View application function
    function viewApplication(applicationId) {
        $.ajax({
            url: "{{ route('admin.job_applications.show') }}",
            type: "GET",
            data: { id: applicationId },
            success: function(response) {
                $('#applicationViewContent').html(response);
                $('#applicationViewModal').modal('show');
            },
            error: function() {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'Failed to load application details'
                });
            }
        });
    }

    // Update application status function
    function updateApplicationStatus(applicationId, status, element) {
        $('#applicationId').val(applicationId);
        $('#statusSelect').val(status);
        $('#statusUpdateModal').modal('show');
    }

    // Submit status update
    function submitStatusUpdate() {
        const formData = $('#statusUpdateForm').serialize();
        
        Swal.fire({
            title: 'Please wait...',
            text: 'Updating application status',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $.ajax({
            url: "{{ url('/admin/job-applications') }}/" + $('#applicationId').val() + "/update-status",
            type: "POST",
            data: formData,
            success: function(response) {
                Swal.close();
                
                if (response.status === 'success') {
                    Swal.fire({
                        icon: 'success',
                        title: 'Status Updated',
                        text: response.message,
                        timer: 1500,
                        showConfirmButton: false
                    }).then(() => {
                        location.reload();
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: response.message || 'Failed to update status'
                    });
                }
            },
            error: function(xhr) {
                Swal.close();
                
                let errorMessage = 'Something went wrong';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    errorMessage = xhr.responseJSON.message;
                }

                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: errorMessage
                });
            }
        });
    }
</script>

