@include('Admin.Includes.header')
@php
    use Illuminate\Support\Facades\Auth;
    use App\General\GeneralSettingsClass;
@endphp

<div class="page-content">
    <div class="container-fluid">
        <!-- Page Inner Start -->
        <div class="page-inner">
            <!-- Breadcrumb -->
            <div class="card shadow-sm mb-4">

                <div class="p-3 d-flex justify-content-between align-items-center">
                    <div>
                        <h1 class="fs-4 fw-bold h3 mb-1">{{ __('General Settings') }}</h1>

                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb bg-transparent p-0 m-0">
                                <li class="breadcrumb-item">
                                    <a href="{{ url('/') }}/admin" class=" link-primary text-decoration-none">
                                        <i class="fa-solid fa-home me-1"></i> Dashboard
                                    </a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">
                                    General Settings
                                </li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>

            <!-- /Breadcrumb -->

            <!-- Content Area -->
            <div class="col-md-12 col-lg-12 px-0">
                <!-- Alerts Section -->
                @if (session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif

                @if ($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <ul class="mb-0">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                            <li><i class="fas fa-info-circle me-1"></i>If you have already selected logo Images, please
                                select them again!</li>
                        </ul>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif

                <!-- Main Form -->
                <form id="general-settings-form" method="POST" action="{{ url('/') }}/admin/general-settings"
                    enctype="multipart/form-data">
                    @csrf
                    <div class="row">
                        <!-- Left Column - Main Settings -->
                        <div class="col-lg-8">
                            <!-- Website View Settings -->
                            <div class="card shadow-sm mb-4">
                                <div class="card-header   py-3">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <h6 class="card-title fw-bold mb-0"><i
                                                class="fas fa-desktop me-2"></i>{{ __('Website View Settings') }}</h6>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="form-group mb-3">
                                        <label class="form-label fw-medium">Tagline</label>
                                        <input class="form-control" type="text" name="_tagline"
                                            placeholder="Free shipping across Australia for orders over $4999"
                                            value="{{ GeneralSettingsClass::getOptionValue('_tagline', $settings) }}">
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">Header Logo</label>
                                                <input type="file" class="form-control" name="_header_logo"
                                                    id="header_logo_input"
                                                    data-default-file="{{ url('/') . '/' . GeneralSettingsClass::getOptionValue('_header_logo', $settings) }}" />
                                            </div>
                                            <div id="header_image_preview" class="text-center mb-4 p-2 rounded bg-light"
                                                style="height: 5rem; {{ is_null($headerLogo) ? 'display: none;' : '' }}">
                                                <img id="preview_img_header" src="{{ asset($headerLogo) ?? '#' }}"
                                                    class="h-100" alt="Header Logo Preview" />
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            @php
                                                $favIcon = GeneralSettingsClass::getOptionValue('_fav_icon', $settings);
                                            @endphp
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">Fav Icon</label>
                                                <input type="file" class="form-control" name="_fav_icon"
                                                    id="fav_icon_input"
                                                    data-default-file="{{ url('/') . '/' . $favIcon }}" />
                                            </div>
                                            <div id="fav_icon_preview" class="text-center mb-4 p-2 rounded bg-light"
                                                style="height: 5rem; {{ is_null($favIcon) ? 'display: none;' : '' }}">
                                                <img id="fav_icon_img" src="{{ asset($favIcon) ?? '#' }}"
                                                    class="h-100" alt="Fav Icon Preview" />
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">Header Logo Dark</label>
                                                <input type="file" class="form-control" name="_header_logo_dark"
                                                    id="header_logo_input_dark"
                                                    data-default-file="{{ url('/') . '/' . GeneralSettingsClass::getOptionValue('_header_logo_dark', $settings) }}" />
                                            </div>
                                            <div id="header_image_preview_dark"
                                                class="text-center mb-4 p-2 rounded bg-light"
                                                style="height: 5rem; {{ is_null($headerLogoDark) ? 'display: none;' : '' }}">
                                                <img id="preview_img_header_dark"
                                                    src="{{ asset($headerLogoDark) ?? '#' }}" class="h-100"
                                                    alt="Header Logo Dark Preview" />
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">GST Percentage</label>
                                                <div class="input-group">
                                                    <input class="form-control" type="number" name="_gst_percentage"
                                                        placeholder="10"
                                                        value="{{ ($gstValue = GeneralSettingsClass::getOptionValue('_gst_percentage', $settings)) !== '' ? $gstValue : '' }}">
                                                    <span class="input-group-text">%</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Truck Pricing Settings -->
                            <div class="card shadow-sm mb-4">
                                <div class="card-header py-3">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <h6 class="card-title fw-bold mb-0"><i
                                                class="fas fa-truck me-2"></i>{{ __('Truck Pricing Settings') }}</h6>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                       
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">Per Meter Cube Price</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">$</span>
                                                    <input class="form-control" type="number" step="0.01" name="_truck_per_cubic_meter_price"
                                                        placeholder="0.00"
                                                        value="{{ ($truckPrice = GeneralSettingsClass::getOptionValue('_truck_per_cubic_meter_price', $settings)) !== '' ? $truckPrice : '' }}">
                                                    <span class="input-group-text">/m³</span>
                                                </div>
                                                <small class="text-muted">Price per cubic meter of cargo</small>
                                            </div>
                                        </div>
                    
                                    </div>
                                </div>
                            </div>

                            <!-- Mover Pricing Settings -->
                            <div class="card shadow-sm mb-4">
                                <div class="card-header py-3">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <h6 class="card-title fw-bold mb-0"><i
                                                class="fas fa-users me-2"></i>{{ __('Mover Pricing Settings') }}</h6>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <!-- Local Job Settings -->
                                        <div class="col-md-6">
                                            <h6 class="text-primary mb-3"><i class="fas fa-map-marker-alt me-2"></i>Local Job</h6>
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">Number of Movers</label>
                                                <input class="form-control" type="number" step="1" min="1" name="_local_job_number_of_movers"
                                                    placeholder="2"
                                                    value="{{ ($localMovers = GeneralSettingsClass::getOptionValue('_local_job_number_of_movers', $settings)) !== '' ? $localMovers : '' }}">
                                                <small class="text-muted">Default number of movers for local jobs</small>
                                            </div>
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">Mover Price Per Hour</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">$</span>
                                                    <input class="form-control" type="number" step="0.01" name="_local_job_mover_per_hour_price"
                                                        placeholder="85.00"
                                                        value="{{ ($localPrice = GeneralSettingsClass::getOptionValue('_local_job_mover_per_hour_price', $settings)) !== '' ? $localPrice : '' }}">
                                                    <span class="input-group-text">/hour</span>
                                                </div>
                                                <small class="text-muted">Price per mover per hour for local jobs</small>
                                            </div>
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">Minimum Order Amount</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">$</span>
                                                    <input class="form-control" type="number" step="0.01" name="_local_job_minimum_order"
                                                        placeholder="0.00"
                                                        value="{{ ($localMin = GeneralSettingsClass::getOptionValue('_local_job_minimum_order', $settings)) !== '' ? $localMin : '' }}">
                                                </div>
                                                <small class="text-muted">Minimum order amount for local jobs</small>
                                            </div>
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">First Deposit Amount</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">$</span>
                                                    <input class="form-control" type="number" step="0.01" name="_local_job_deposit_amount"
                                                        placeholder="100.00"
                                                        value="{{ ($localDeposit = GeneralSettingsClass::getOptionValue('_local_job_deposit_amount', $settings)) !== '' ? $localDeposit : '' }}">
                                                </div>
                                                <small class="text-muted">Fixed deposit amount in dollars for local jobs</small>
                                            </div>
                                        </div>

                                        <!-- Interstate Job Settings -->
                                        <div class="col-md-6">
                                            <h6 class="text-info mb-3"><i class="fas fa-route me-2"></i>Interstate Job</h6>
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">Number of Movers</label>
                                                <input class="form-control" type="number" step="1" min="1" name="_interstate_job_number_of_movers"
                                                    placeholder="2"
                                                    value="{{ ($interstateMovers = GeneralSettingsClass::getOptionValue('_interstate_job_number_of_movers', $settings)) !== '' ? $interstateMovers : '' }}">
                                                <small class="text-muted">Default number of movers for interstate jobs</small>
                                            </div>
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">Mover Price Per Hour</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">$</span>
                                                    <input class="form-control" type="number" step="0.01" name="_interstate_job_mover_per_hour_price"
                                                        placeholder="110.00"
                                                        value="{{ ($interstatePrice = GeneralSettingsClass::getOptionValue('_interstate_job_mover_per_hour_price', $settings)) !== '' ? $interstatePrice : '' }}">
                                                    <span class="input-group-text">/hour</span>
                                                </div>
                                                <small class="text-muted">Price per mover per hour for interstate jobs</small>
                                            </div>
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">Minimum Order Amount</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">$</span>
                                                    <input class="form-control" type="number" step="0.01" name="_interstate_job_minimum_order"
                                                        placeholder="0.00"
                                                        value="{{ ($interstateMin = GeneralSettingsClass::getOptionValue('_interstate_job_minimum_order', $settings)) !== '' ? $interstateMin : '' }}">
                                                </div>
                                                <small class="text-muted">Minimum order amount for interstate jobs</small>
                                            </div>
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">First Deposit Percentage</label>
                                                <div class="input-group">
                                                    <input class="form-control" type="number" step="0.01" min="0" max="100" name="_interstate_job_deposit_percentage"
                                                        placeholder="20.00"
                                                        value="{{ ($interstateDeposit = GeneralSettingsClass::getOptionValue('_interstate_job_deposit_percentage', $settings)) !== '' ? $interstateDeposit : '' }}">
                                                    <span class="input-group-text">%</span>
                                                </div>
                                                <small class="text-muted">Deposit percentage of total amount for interstate jobs</small>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="alert alert-info">
                                        <i class="fas fa-info-circle me-2"></i>
                                        <strong>Note:</strong> The minimum hourly rate will be automatically applied based on the number of movers and their hourly rate. Extra movers are charged at $50/hour each.
                                    </div>

                                    <div class="form-group mb-3">
                                        <label class="form-label fw-medium">Buffer/Multiplier Time Percentage</label>
                                        <div class="input-group">
                                            <input class="form-control" type="number" step="0.01" min="0" max="100" name="_buffer_multiplier_time_percentage"
                                                placeholder="20.00"
                                                value="{{ ($bufferMultiplierTimePercentage = GeneralSettingsClass::getOptionValue('_buffer_multiplier_time_percentage', $settings)) !== '' ? $bufferMultiplierTimePercentage : '' }}">
                                            <span class="input-group-text">%</span>
                                        </div>
                                        <small class="text-muted">Buffer/Multiplier time percentage for callout fee</small>
                                    </div>
                                </div>
                            </div>

                            <!-- SMTP Settings -->
                            <div class="card shadow-sm mb-4">
                                <div class="card-header   py-3">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <h6 class="card-title fw-bold mb-0"><i
                                                class="fas fa-envelope me-2"></i>{{ __('SMTP Credentials Settings') }}
                                        </h6>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">Mail Mailer</label>
                                                <input class="form-control" type="text" name="_mail_mailer"
                                                    placeholder="smtp"
                                                    value="{{ GeneralSettingsClass::getOptionValue('_mail_mailer', $settings) }}">
                                            </div>
                                        </div>
                                        <div class="col-md-8">
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">Mail Host</label>
                                                <input class="form-control" type="text" name="_mail_host"
                                                    placeholder="smtp.example.com"
                                                    value="{{ GeneralSettingsClass::getOptionValue('_mail_host', $settings) }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">Mail Port</label>
                                                <input class="form-control" type="text" name="_mail_port"
                                                    placeholder="587"
                                                    value="{{ GeneralSettingsClass::getOptionValue('_mail_port', $settings) }}">
                                            </div>
                                        </div>
                                        <div class="col-md-8">
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">Mail Username</label>
                                                <input class="form-control" type="text" name="_mail_username"
                                                    placeholder="user@example.com"
                                                    value="{{ GeneralSettingsClass::getOptionValue('_mail_username', $settings) }}">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">Mail Encryption</label>
                                                <input class="form-control" type="text" name="_mail_encrption"
                                                    placeholder="tls"
                                                    value="{{ GeneralSettingsClass::getOptionValue('_mail_encrption', $settings) }}">
                                            </div>
                                        </div>
                                        <div class="col-md-8">
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">Mail Password</label>
                                                <div class="input-group">
                                                    <input class="form-control" type="password" name="_mail_password"
                                                        placeholder="********" id="password"
                                                        value="{{ GeneralSettingsClass::getOptionValue('_mail_password', $settings) }}">
                                                    <button class="btn btn-outline-secondary" type="button"
                                                        id="togglePassword">
                                                        <i class="far fa-eye" id="togglePasswordIcon"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">Mail From Name</label>
                                                <input class="form-control" type="text" name="_mail_from_name"
                                                    placeholder="Your Company Name"
                                                    value="{{ GeneralSettingsClass::getOptionValue('_mail_from_name', $settings) }}">
                                            </div>
                                        </div>
                                        <div class="col-md-8">
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">Mail From Address</label>
                                                <input class="form-control" type="text" name="_mail_from_address"
                                                    placeholder="no-reply@example.com"
                                                    value="{{ GeneralSettingsClass::getOptionValue('_mail_from_address', $settings) }}">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Stripe Payment Settings -->
                            {{-- <div class="card shadow-sm mb-4">
                                <div class="card-header py-3">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <h6 class="card-title fw-bold mb-0"><i
                                                class="fas fa-credit-card me-2"></i>{{ __('Stripe Payment Settings') }}
                                        </h6>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">Active Environment</label>
                                                <select class="form-select" name="_active_stripe_environment" id="stripe_environment">
                                                    <option value="sandbox" {{ GeneralSettingsClass::getOptionValue('_active_stripe_environment', $settings) == 'sandbox' ? 'selected' : '' }}>Sandbox (Test Mode)</option>
                                                    <option value="live" {{ GeneralSettingsClass::getOptionValue('_active_stripe_environment', $settings) == 'live' ? 'selected' : '' }}>Live (Production Mode)</option>
                                                </select>
                                                <small class="text-muted">Select which Stripe environment to use for payments. API keys are configured in config/services.php</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div> --}}
                        </div>

                        <!-- Right Column - Sidebar Settings -->
                        <div class="col-lg-4">

                            <div class="card shadow-sm rounded-lg mb-4">
                                <div class="card-header bg-gradient-primary text-white py-3">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <h5 class="font-weight-bold mb-0">{{ __('Business Details') }}</h5>
                                    </div>
                                </div>
                                <div class="card-body  ">
                                    <div class="row g-3">
                                        <div class="col-xl-6">
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">Business Name</label>
                                                <div class="input-group">
                                                    <span class="input-group-text"><i
                                                            class="fas fa-building"></i></span>
                                                    <input class="form-control" type="text" name="_b_name"
                                                        placeholder="Enter your business name"
                                                        value="{{ GeneralSettingsClass::getOptionValue('_b_name', $settings) }}">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-6">
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">Email Address</label>
                                                <div class="input-group">
                                                    <span class="input-group-text"><i
                                                            class="fas fa-envelope"></i></span>
                                                    <input class="form-control" type="email" name="_b_email"
                                                        placeholder="Business email for notifications"
                                                        value="{{ GeneralSettingsClass::getOptionValue('_b_email', $settings) }}">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-6">
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">Phone Number</label>
                                                <div class="input-group">
                                                    <span class="input-group-text"><i class="fas fa-phone"></i></span>
                                                    <input class="form-control" type="text" name="_b_number"
                                                        placeholder="Business contact number"
                                                        value="{{ GeneralSettingsClass::getOptionValue('_b_number', $settings) }}">
                                                </div>
                                            </div>
                                        </div> 
                                        <div class="col-xl-6">
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">WhatsApp Number</label>
                                                <div class="input-group">
                                                    <span class="input-group-text"><i class="fas fa-phone"></i></span>
                                                    <input class="form-control" type="text" name="_whats_app_number"
                                                        placeholder="Business contact number"
                                                        value="{{ GeneralSettingsClass::getOptionValue('_whats_app_number', $settings) }}">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-6">
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">Landline Number</label>
                                                <div class="input-group">
                                                    <span class="input-group-text"><i class="fas fa-phone"></i></span>
                                                    <input class="form-control" type="text" name="_b_landline_number"
                                                        placeholder="Business landline number"
                                                        value="{{ GeneralSettingsClass::getOptionValue('_b_landline_number', $settings) }}">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-6">
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">ABN</label>
                                                <div class="input-group">
                                                    <span class="input-group-text"><i
                                                            class="fas fa-id-card"></i></span>
                                                    <input class="form-control" type="text" name="_abn"
                                                        placeholder="Australian Business Number"
                                                        value="{{ GeneralSettingsClass::getOptionValue('_abn', $settings) }}">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <hr class="my-4">
                                    <h6 class="text-primary mb-3">Banking Information</h6>

                                    <div class="row g-3">
                                        <div class="col-xl-6">
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">Bank Name</label>
                                                <div class="input-group">
                                                    <span class="input-group-text"><i
                                                            class="fas fa-university"></i></span>
                                                    <input class="form-control" type="text" name="_bank_name"
                                                        placeholder="Enter bank name"
                                                        value="{{ GeneralSettingsClass::getOptionValue('_bank_name', $settings) }}">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-6">
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">Bank Account Name</label>
                                                <div class="input-group">
                                                    <span class="input-group-text"><i
                                                            class="fas fa-money-check"></i></span>
                                                    <input class="form-control" type="text" name="_bank_details"
                                                        placeholder="Additional bank details"
                                                        value="{{ GeneralSettingsClass::getOptionValue('_bank_details', $settings) }}">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-6">
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">BSB</label>
                                                <div class="input-group">
                                                    <span class="input-group-text"><i
                                                            class="fas fa-hashtag"></i></span>
                                                    <input class="form-control" type="text" name="_bsb"
                                                        placeholder="BSB number"
                                                        value="{{ GeneralSettingsClass::getOptionValue('_bsb', $settings) }}">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-6">
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">Account Number</label>
                                                <div class="input-group">
                                                    <span class="input-group-text"><i
                                                            class="fas fa-credit-card"></i></span>
                                                    <input class="form-control" type="text" name="_acc"
                                                        placeholder="Account number"
                                                        value="{{ GeneralSettingsClass::getOptionValue('_acc', $settings) }}">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <hr class="my-4">
                                    <h6 class="text-primary mb-3">Location Information</h6>

                                    <div class="row g-3">
                                        <div class="col-xl-6">
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">Area Address</label>
                                                <div class="input-group">
                                                    <span class="input-group-text"><i class="fas fa-map"></i></span>
                                                    <input class="form-control" type="text" name="_b_area_address"
                                                        placeholder="Suburb, City, State"
                                                        value="{{ GeneralSettingsClass::getOptionValue('_b_area_address', $settings) }}">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-6">
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">Street Address</label>
                                                <div class="input-group">
                                                    <span class="input-group-text"><i
                                                            class="fas fa-map-marker-alt"></i></span>
                                                    <input class="form-control" type="text"
                                                        name="_b_street_address" placeholder="Complete street address"
                                                        value="{{ GeneralSettingsClass::getOptionValue('_b_street_address', $settings) }}">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <hr class="my-4">
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <h6 class="text-primary mb-0"><i class="fas fa-building me-2"></i>Business Bases</h6>
                                        <button type="button" class="btn btn-sm btn-primary" id="add-base-btn">
                                            <i class="fas fa-plus me-1"></i> Add Base
                                        </button>
                                    </div>
                                    <p class="text-muted small mb-3">Manage multiple business locations/bases</p>
                                    
                                    <div id="bases-container">
                                        @php
                                            $basesJson = GeneralSettingsClass::getOptionValue('_bases', $settings);
                                            $bases = [];
                                            if ($basesJson) {
                                                $decoded = json_decode($basesJson, true);
                                                if (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) {
                                                    $bases = $decoded;
                                                }
                                            }
                                            // If no bases exist, show empty fields with placeholders
                                            if (empty($bases)) {
                                                $bases = [
                                                    ['address' => ''],
                                                    ['address' => '']
                                                ];
                                            }
                                        @endphp
                                        @foreach($bases as $index => $base)
                                            <div class="base-item card mb-3" data-index="{{ $index }}">
                                                <div class="card-body">
                                                    <div class="d-flex justify-content-between align-items-start mb-2">
                                                        <h6 class="mb-0 text-secondary">Base {{ $index + 1 }}</h6>
                                                        <button type="button" class="btn btn-sm btn-danger remove-base-btn">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </div>
                                                    <div class="form-group mb-0">
                                                        <label class="form-label fw-medium small">Address</label>
                                                        <input type="text" 
                                                            class="form-control" 
                                                            name="_bases[{{ $index }}][address]" 
                                                            placeholder="e.g., 76 Brunswick St, Fortitude Valley QLD 4006, Australia"
                                                            value="{{ !empty($base['address']) ? $base['address'] : '' }}" 
                                                            required>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>

                            <!-- Business Hours -->
                            <div class="card shadow-sm rounded-lg mb-4">
                                <div class="card-header bg-gradient-success text-white py-3">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <h5 class="font-weight-bold mb-0"><i class="fas fa-clock me-2"></i>{{ __('Business Hours') }}</h5>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <!-- Monday - Friday -->
                                    <div class="mb-4">
                                        <label class="form-label fw-medium mb-2">Monday - Friday</label>
                                        <div class="row g-2">
                                            <div class="col-6">
                                                <div class="input-group">
                                                    <span class="input-group-text"><i class="fas fa-clock"></i></span>
                                                    <input class="form-control" type="time" name="_hours_mon_fri_open"
                                                        placeholder="Open Time"
                                                        value="{{ GeneralSettingsClass::getOptionValue('_hours_mon_fri_open', $settings) ? GeneralSettingsClass::getOptionValue('_hours_mon_fri_open', $settings) : '07:00' }}">
                                                </div>
                                                <small class="text-muted">Open Time</small>
                                            </div>
                                            <div class="col-6">
                                                <div class="input-group">
                                                    <span class="input-group-text"><i class="fas fa-clock"></i></span>
                                                    <input class="form-control" type="time" name="_hours_mon_fri_close"
                                                        placeholder="Close Time"
                                                        value="{{ GeneralSettingsClass::getOptionValue('_hours_mon_fri_close', $settings) ? GeneralSettingsClass::getOptionValue('_hours_mon_fri_close', $settings) : '19:00' }}">
                                                </div>
                                                <small class="text-muted">Close Time</small>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Saturday -->
                                    <div class="mb-4">
                                        <label class="form-label fw-medium mb-2">Saturday</label>
                                        <div class="row g-2">
                                            <div class="col-6">
                                                <div class="input-group">
                                                    <span class="input-group-text"><i class="fas fa-clock"></i></span>
                                                    <input class="form-control" type="time" name="_hours_sat_open"
                                                        placeholder="Open Time"
                                                        value="{{ GeneralSettingsClass::getOptionValue('_hours_sat_open', $settings) ? GeneralSettingsClass::getOptionValue('_hours_sat_open', $settings) : '09:00' }}">
                                                </div>
                                                <small class="text-muted">Open Time</small>
                                            </div>
                                            <div class="col-6">
                                                <div class="input-group">
                                                    <span class="input-group-text"><i class="fas fa-clock"></i></span>
                                                    <input class="form-control" type="time" name="_hours_sat_close"
                                                        placeholder="Close Time"
                                                        value="{{ GeneralSettingsClass::getOptionValue('_hours_sat_close', $settings) ? GeneralSettingsClass::getOptionValue('_hours_sat_close', $settings) : '16:00' }}">
                                                </div>
                                                <small class="text-muted">Close Time</small>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Sunday -->
                                    <div class="mb-3">
                                        <label class="form-label fw-medium mb-2">Sunday</label>
                                        <div class="form-check mb-3">
                                            <input class="form-check-input" type="checkbox" name="_hours_sun_closed" 
                                                id="sunday_closed_checkbox" value="1"
                                                {{ GeneralSettingsClass::getOptionValue('_hours_sun_closed', $settings) == '1' ? 'checked' : '' }}>
                                            <label class="form-check-label" for="sunday_closed_checkbox">
                                                Closed on Sunday
                                            </label>
                                        </div>
                                        <div id="sunday_hours" style="{{ GeneralSettingsClass::getOptionValue('_hours_sun_closed', $settings) == '1' ? 'display: none;' : '' }}">
                                            <div class="row g-2">
                                                <div class="col-6">
                                                    <div class="input-group">
                                                        <span class="input-group-text"><i class="fas fa-clock"></i></span>
                                                        <input class="form-control" type="time" name="_hours_sun_open"
                                                            placeholder="Open Time"
                                                            value="{{ GeneralSettingsClass::getOptionValue('_hours_sun_open', $settings) ? GeneralSettingsClass::getOptionValue('_hours_sun_open', $settings) : '' }}">
                                                    </div>
                                                    <small class="text-muted">Open Time</small>
                                                </div>
                                                <div class="col-6">
                                                    <div class="input-group">
                                                        <span class="input-group-text"><i class="fas fa-clock"></i></span>
                                                        <input class="form-control" type="time" name="_hours_sun_close"
                                                            placeholder="Close Time"
                                                            value="{{ GeneralSettingsClass::getOptionValue('_hours_sun_close', $settings) ? GeneralSettingsClass::getOptionValue('_hours_sun_close', $settings) : '' }}">
                                                    </div>
                                                    <small class="text-muted">Close Time</small>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="card shadow-sm rounded-lg mb-4">
                                <div class="card-header bg-gradient-info text-white py-3">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <h5 class="font-weight-bold mb-0">{{ __('Social Media Profiles') }}</h5>
                                    </div>
                                </div>
                                <div class="card-body  ">
                                    <div class="row g-3">
                                        <div class="col-xl-6">
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">Instagram</label>
                                                <div class="input-group">
                                                    <span class="input-group-text bg-instagram text-balck"><i
                                                            class="fab fa-instagram"></i></span>
                                                    <input class="form-control" type="text" name="_instagram_link"
                                                        placeholder="Instagram profile URL"
                                                        value="{{ GeneralSettingsClass::getOptionValue('_instagram_link', $settings) ? GeneralSettingsClass::getOptionValue('_instagram_link', $settings) : '#' }}">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-6">
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">Facebook</label>
                                                <div class="input-group">
                                                    <span class="input-group-text bg-facebook text-balck"><i
                                                            class="fab fa-facebook-f"></i></span>
                                                    <input class="form-control" type="text" name="_facebook_link"
                                                        placeholder="Facebook page URL"
                                                        value="{{ GeneralSettingsClass::getOptionValue('_facebook_link', $settings) ? GeneralSettingsClass::getOptionValue('_facebook_link', $settings) : '#' }}">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-6">
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">Twitter</label>
                                                <div class="input-group">
                                                    <span class="input-group-text bg-twitter text-black"><i
                                                            class="fab fa-x-twitter"></i></span>
                                                    <input class="form-control" type="text" name="_twitter_link"
                                                        placeholder="Twitter profile URL"
                                                        value="{{ GeneralSettingsClass::getOptionValue('_twitter_link', $settings) ? GeneralSettingsClass::getOptionValue('_twitter_link', $settings) : '#' }}">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-6">
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">YouTube</label>
                                                <div class="input-group">
                                                    <span class="input-group-text bg-youtube text-black"><i
                                                            class="fab fa-youtube"></i></span>
                                                    <input class="form-control" type="text" name="_youtube_link"
                                                        placeholder="YouTube channel URL"
                                                        value="{{ GeneralSettingsClass::getOptionValue('_youtube_link', $settings) ? GeneralSettingsClass::getOptionValue('_youtube_link', $settings) : '#' }}">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-6">
                                            <div class="form-group mb-3">
                                                <label class="form-label fw-medium">LinkedIn</label>
                                                <div class="input-group">
                                                    <span class="input-group-text bg-linkedin text-black"><i
                                                            class="fab fa-linkedin-in"></i></span>
                                                    <input class="form-control" type="text" name="_linke_din"
                                                        placeholder="LinkedIn profile URL"
                                                        value="{{ GeneralSettingsClass::getOptionValue('_linke_din', $settings) ? GeneralSettingsClass::getOptionValue('_linke_din', $settings) : '#' }}">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="text-end mb-4">
                                <button type="submit" class="btn btn-success px-4 py-2">
                                    <i class="fas fa-save me-2"></i> Save Changes
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <!--/  Order Active dataTable End -->
            <!--================================-->
        </div>
        <!--/ Page Inner End -->




    </div>
</div>

<script>
    $(document).ready(function() {
        // Mail password toggle
        $("#togglePassword").click(function() {
            var passwordField = $("#password");
            var fieldType = passwordField.attr("type");
            var icon = $("#togglePasswordIcon");

            if (fieldType === "password") {
                passwordField.attr("type", "text");
                icon.removeClass("fa-eye").addClass("fa-eye-slash");
            } else {
                passwordField.attr("type", "password");
                icon.removeClass("fa-eye-slash").addClass("fa-eye");
            }
        });

    });
</script>
<script>
    $(document).ready(function() {
        $("#footer_logo_input").change(function() {
            readURL(this);
        });

        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function(e) {
                    $("#preview_img").attr("src", e.target.result);
                    $("#image_preview").show();
                };

                reader.readAsDataURL(input.files[0]);
            }
        }

        $("#header_logo_input").change(function() {
            readHeaderLogoURL(this);
        });

        function readHeaderLogoURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function(e) {
                    $("#preview_img_header").attr("src", e.target.result);
                    $("#header_image_preview").show();
                };

                reader.readAsDataURL(input.files[0]);
            }
        }

        // Sunday closed checkbox toggle
        $('#sunday_closed_checkbox').change(function() {
            if ($(this).is(':checked')) {
                $('#sunday_hours').hide();
                $('input[name="_hours_sun_open"]').val('');
                $('input[name="_hours_sun_close"]').val('');
            } else {
                $('#sunday_hours').show();
            }
        });

        // Bases management
        let baseIndex = $('#bases-container .base-item').length;
        
        // Add new base
        $('#add-base-btn').click(function() {
            const baseHtml = `
                <div class="base-item card mb-3" data-index="${baseIndex}">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-start mb-2">
                            <h6 class="mb-0 text-secondary">Base ${baseIndex + 1}</h6>
                            <button type="button" class="btn btn-sm btn-danger remove-base-btn">
                                <i class="fas fa-trash"></i>
                            </button>
                        </div>
                        <div class="form-group mb-0">
                            <label class="form-label fw-medium small">Address</label>
                            <input type="text" 
                                class="form-control" 
                                name="_bases[${baseIndex}][address]" 
                                placeholder="e.g., 76 Brunswick St, Fortitude Valley QLD 4006, Australia"
                                required>
                        </div>
                    </div>
                </div>
            `;
            $('#bases-container').append(baseHtml);
            baseIndex++;
            updateBaseNumbers();
        });

        // Remove base
        $(document).on('click', '.remove-base-btn', function() {
            const baseItem = $(this).closest('.base-item');
            if ($('#bases-container .base-item').length > 1) {
                baseItem.fadeOut(300, function() {
                    $(this).remove();
                    updateBaseNumbers();
                });
            } else {
                alert('You must have at least one base.');
            }
        });

        // Update base numbers after add/remove
        function updateBaseNumbers() {
            $('#bases-container .base-item').each(function(index) {
                $(this).find('h6').text('Base ' + (index + 1));
            });
        }
    });
</script>
